package com.bxm.adsprod.counter.ticket.cashier;

import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.common.message.AbstractMessageListener;
import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.counter.event.BalanceNotEnoughEvent;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>广告主收银员，每一次点击扣款一次</h3>
 * <p>该实现需要结合{@link com.bxm.adsprod.facade.advertiser.AdvertiserService}使用</p>
 *
 * @see com.bxm.adsprod.facade.advertiser.AdvertiserService#incrementBalance(BigInteger, Long)
 * @author allen
 * @since V1.0.0 2017/12/15
 */
@Component
@EnableConfigurationProperties({AlionsConfiguration.class, Configuration.class})
public class AdvertiserCashier extends AbstractMessageListener {

    @Autowired
    @Qualifier("jedisCounter")
    private Counter counter;
    @Autowired
    private AlionsConfiguration alionsConfiguration;
    @Autowired
    private Configuration local;
    @Autowired
    private EventPark eventPark;

    protected long getIncrementValue(ClickRequest request, Ticket ticket) {
        return - (ticket.isCPC() ? ticket.getPrice() : 0);
    }

    @Override
    protected void consume(Message message, Object request, Object returning) {
        consume((ClickRequest) request, (Ticket) returning);
    }

    protected void consume(ClickRequest request, Ticket ticket) {
        long incrementValue = getIncrementValue(request, ticket);
        increment(request.getUid(), ticket, incrementValue);
    }

    private void increment(String uid, Ticket ticket, long inc) {
        KeyGenerator keyGenerator = TicketKeyGenerator.Advertiser.getBalance();
        Long remain = counter.hincrementByAndGet(keyGenerator, String.valueOf(ticket.getAdvertiser()), inc);
        if (remain <= 0) {
            eventPark.post(new BalanceNotEnoughEvent(this, ticket));
        }
    }

    @Override
    public String getTopic() {
        return local.getTopic().getClick();
    }

    @Bean
    public Consumer advertiserCashierConsumer() {
        return createConsumer(local.getConsumer().getAdvertiserCashier(), alionsConfiguration.getAccessKey(), alionsConfiguration.getSecretKey());
    }
}
