package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>日曝光次数统计</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@Component
@EnableConfigurationProperties({AlionsConfiguration.class, Configuration.class})
public class TicketDailyViewCounter extends AbstractViewCounter implements HashCounter {

    @Autowired
    private AlionsConfiguration configuration;
    @Autowired
    private Configuration local;

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getViewOfDaily();
    }

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return String.valueOf(ticketId);
    }

    @Bean
    public Consumer ticketDailyViewCounterConsumer() {
        return createConsumer(local.getConsumer().getTicketDailyView(),
                configuration.getAccessKey(), configuration.getSecretKey());
    }
}
