package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>广告券用户每天点击次数统计</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@Component
@EnableConfigurationProperties({AlionsConfiguration.class, Configuration.class})
public class TicketUserDailyClickCounter extends AbstractClickCounter implements HashCounter {

    @Autowired
    private AlionsConfiguration configuration;
    @Autowired
    private Configuration local;

    @Override
    protected int getExpireTimeInSeconds() {
        return TypeHelper.castToInt(DateHelper.getRemainSecondsOfToday());
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getClickOfDaily(ticketId);
    }

    @Bean
    public Consumer ticketUserDailyClickCounterConsumer() {
        return createConsumer(local.getConsumer().getTicketUserDailyClick(),
                configuration.getAccessKey(), configuration.getSecretKey());
    }

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return uid;
    }
}
