package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.common.message.AbstractMessageListener;
import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.counter.ticket.counter.entity.TicketWeightBaseData;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * @author allen
 * @since 1.0.0
 */
@Component
@EnableConfigurationProperties(Configuration.class)
public class TicketViewCounter extends AbstractMessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketViewCounter.class);
    @Autowired
    private AlionsConfiguration alionsConfiguration;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Configuration configuration;

    @Override
    protected void consume(Message message, Object request, Object returning) {
        consume(message, (ViewRequest) request, (Ticket) returning);
    }

    private void consume(Message message, ViewRequest request, Ticket ticket) {
        BigInteger ticketId = ticket.getId();

        TicketWeightBaseData o = new TicketWeightBaseData();
        o.setSettleType(ticket.getSettleType());
        o.setModeltype(TicketWeightBaseData.MODELTYPE_VIEW);
        o.setModelvalue(1);
        o.setTicketid(ticketId);
        o.setTime(ticket.getTime());

        mongoTemplate.insert(o);
    }

    @Override
    public String getTopic() {
        return configuration.getTopic().getView();
    }

    @Bean
    public Consumer ticketViewCountConsumer() {
        return createConsumer(configuration.getConsumer().getTicketView(), alionsConfiguration.getAccessKey(), alionsConfiguration.getSecretKey());
    }
}
