/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.event.listeners;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.common.eventbus.EventListener;
import com.bxm.adsprod.counter.event.BalanceNotEnoughEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.google.common.eventbus.Subscribe;
import java.math.BigInteger;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BalanceNotEnoughEventListener
implements EventListener<BalanceNotEnoughEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BalanceNotEnoughEventListener.class);
    @Reference(version="1.0.0")
    private TicketService ticketService;

    @Subscribe
    public void consume(BalanceNotEnoughEvent event) {
        Ticket ticket = event.getTicket();
        BigInteger advertiser = ticket.getAdvertiser();
        List allTickets = this.ticketService.getAllTickets();
        for (Ticket e : allTickets) {
            boolean isSameAdvertiser = null != e.getAdvertiser() && e.getAdvertiser().equals(advertiser);
            if (!isSameAdvertiser || !e.isAvailableForStatus()) continue;
            BigInteger id = e.getId();
            boolean flag = this.ticketService.updateTicketStatus(id, (byte)2, 2);
            if (flag) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6682\u505c-\u4f59\u989d\u4e0d\u8db3)\u66f4\u65b0\u5b8c\u6210", (Object)id);
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("\u5e7f\u544a\u5238({})\u72b6\u6001(\u6682\u505c-\u4f59\u989d\u4e0d\u8db3)\u66f4\u65b0\u5931\u8d25!", (Object)id);
        }
    }
}

