/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket;

import com.bxm.adsprod.common.message.AbstractMessageListener;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractCounter<REQUEST, RETURNING>
extends AbstractMessageListener {
    public static final long DEFAULT_INCREMENT_VALUE = 1L;
    @Autowired
    @Qualifier(value="jedisCounter")
    protected Counter counter;

    protected abstract REQUEST convertRequest(Object var1);

    protected abstract RETURNING convertReturning(Object var1);

    protected abstract KeyGenerator getKeyGenerator(String var1, BigInteger var2);

    protected abstract long getIncrementValue(REQUEST var1, RETURNING var2);

    protected abstract String getUid(REQUEST var1, RETURNING var2);

    protected abstract BigInteger getTicketId(REQUEST var1, RETURNING var2);

    protected int getExpireTimeInSeconds() {
        return TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfDay((int)10));
    }

    protected void afterIncrement(long val, REQUEST request, RETURNING returning) {
    }

    protected final void consume(Message message, Object request, Object returning) {
        REQUEST r = this.convertRequest(request);
        RETURNING rtn = this.convertReturning(returning);
        long incrementValue = this.getIncrementValue(r, rtn);
        String uid = this.getUid(r, rtn);
        BigInteger ticketId = this.getTicketId(r, rtn);
        Long rst = this.increment(uid, ticketId, incrementValue);
        this.afterIncrement(rst, r, rtn);
    }

    protected final Long increment(String uid, BigInteger ticketId, long inc) {
        if (this instanceof HashCounter) {
            String field = ((HashCounter)((Object)this)).getField(uid, ticketId);
            return this.counter.hincrementByAndGet(this.getKeyGenerator(uid, ticketId), field, inc, this.getExpireTimeInSeconds());
        }
        return this.counter.incrementByAndGet(this.getKeyGenerator(uid, ticketId), inc, this.getExpireTimeInSeconds());
    }
}

