/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.common.message.AbstractMessageListener;
import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.counter.ticket.counter.entity.TicketWeightBaseData;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={Configuration.class})
public class TicketClickCounter
extends AbstractMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketClickCounter.class);
    @Autowired
    private AlionsConfiguration alionsConfiguration;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Configuration configuration;

    protected void consume(Message message, Object request, Object returning) {
        this.consume(message, (ClickRequest)request, (Ticket)returning);
    }

    private void consume(Message message, ClickRequest request, Ticket ticket) {
        BigInteger ticketId = ticket.getId();
        TicketWeightBaseData o = new TicketWeightBaseData();
        o.setSettleType(ticket.getSettleType());
        o.setModeltype(7);
        o.setModelvalue(ticket.getPrice());
        o.setTicketid(ticketId);
        o.setTime(ticket.getTime());
        this.mongoTemplate.insert((Object)o);
    }

    public String getTopic() {
        return this.configuration.getTopic().getClick();
    }

    @Bean
    public Consumer ticketClickCountConsumer() {
        return this.createConsumer(this.configuration.getConsumer().getTicketClick(), this.alionsConfiguration.getAccessKey(), this.alionsConfiguration.getSecretKey());
    }
}

