/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.counter.event.BudgetNotEnoughOfDailyEvent;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import java.math.BigInteger;
import java.util.EventObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={AlionsConfiguration.class, Configuration.class})
public class TicketForCpaDailyBudgetCounter
extends AbstractViewCounter
implements HashCounter {
    @Autowired
    private AlionsConfiguration configuration;
    @Autowired
    private Configuration local;
    @Autowired
    private EventPark eventPark;

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return String.valueOf(ticketId);
    }

    @Override
    protected long getIncrementValue(ViewRequest ticketRequest, Ticket ticket) {
        return ticket.isCPC() ? 0L : 1L;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfDaily();
    }

    @Override
    protected void afterIncrement(long val, ViewRequest viewRequest, Ticket ticket) {
        if (val >= (long)ticket.getBudgetDaily().intValue()) {
            this.eventPark.post((EventObject)new BudgetNotEnoughOfDailyEvent(this, ticket));
        }
    }

    @Bean
    public Consumer ticketCpaDailyBudgetCounterConsumer() {
        return this.createConsumer(this.local.getConsumer().getTicketCpaDailyBudget(), this.configuration.getAccessKey(), this.configuration.getSecretKey());
    }
}

