/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={AlionsConfiguration.class, Configuration.class})
public class TicketUserDailyViewCounter
extends AbstractViewCounter
implements HashCounter {
    @Autowired
    private AlionsConfiguration configuration;
    @Autowired
    private Configuration local;

    @Override
    protected int getExpireTimeInSeconds() {
        return TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfToday());
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getViewOfDaily((BigInteger)ticketId);
    }

    @Bean
    public Consumer ticketUserDailyViewCounterConsumer() {
        return this.createConsumer(this.local.getConsumer().getTicketUserDailyView(), this.configuration.getAccessKey(), this.configuration.getSecretKey());
    }

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return uid;
    }
}

