/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.parser;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.JSONLexerBase;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.SymbolTable;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.ASMUtils;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.IOUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONScanner
extends JSONLexerBase {
    private final String text;
    private final int len;

    public JSONScanner(String input) {
        this(input, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(String input, int features) {
        super(features);
        this.text = input;
        this.len = this.text.length();
        this.bp = -1;
        this.next();
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    @Override
    public final char charAt(int index) {
        if (index >= this.len) {
            return '\u001a';
        }
        return this.text.charAt(index);
    }

    @Override
    public final char next() {
        int index;
        char c = (index = ++this.bp) >= this.len ? (char)'\u001a' : (char)this.text.charAt(index);
        this.ch = c;
        return c;
    }

    public JSONScanner(char[] input, int inputLength) {
        this(input, inputLength, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(char[] input, int inputLength, int features) {
        this(new String(input, 0, inputLength), features);
    }

    @Override
    protected final void copyTo(int offset, int count, char[] dest) {
        this.text.getChars(offset, offset + count, dest, 0);
    }

    static boolean charArrayCompare(String src, int offset, char[] dest) {
        int destLen = dest.length;
        if (destLen + offset > src.length()) {
            return false;
        }
        for (int i = 0; i < destLen; ++i) {
            if (dest[i] == src.charAt(offset + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean charArrayCompare(char[] chars) {
        return JSONScanner.charArrayCompare(this.text, this.bp, chars);
    }

    @Override
    public final int indexOf(char ch, int startIndex) {
        return this.text.indexOf(ch, startIndex);
    }

    @Override
    public final String addSymbol(int offset, int len, int hash, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.text, offset, len, hash);
    }

    @Override
    public byte[] bytesValue() {
        return IOUtils.decodeBase64(this.text, this.np + 1, this.sp);
    }

    @Override
    public final String stringVal() {
        if (!this.hasSpecial) {
            return this.subString(this.np + 1, this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    @Override
    public final String subString(int offset, int count) {
        if (ASMUtils.IS_ANDROID) {
            if (count < this.sbuf.length) {
                this.text.getChars(offset, offset + count, this.sbuf, 0);
                return new String(this.sbuf, 0, count);
            }
            char[] chars = new char[count];
            this.text.getChars(offset, offset + count, chars, 0);
            return new String(chars);
        }
        return this.text.substring(offset, offset + count);
    }

    @Override
    public final char[] sub_chars(int offset, int count) {
        if (ASMUtils.IS_ANDROID && count < this.sbuf.length) {
            this.text.getChars(offset, offset + count, this.sbuf, 0);
            return this.sbuf;
        }
        char[] chars = new char[count];
        this.text.getChars(offset, offset + count, chars, 0);
        return chars;
    }

    @Override
    public final String numberString() {
        char chLocal = this.charAt(this.np + this.sp - 1);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        return this.subString(this.np, sp);
    }

    @Override
    public final BigDecimal decimalValue() {
        char chLocal = this.charAt(this.np + this.sp - 1);
        int sp = this.sp;
        if (chLocal == 'L' || chLocal == 'S' || chLocal == 'B' || chLocal == 'F' || chLocal == 'D') {
            --sp;
        }
        int offset = this.np;
        int count = sp;
        if (count < this.sbuf.length) {
            this.text.getChars(offset, offset + count, this.sbuf, 0);
            return new BigDecimal(this.sbuf, 0, count);
        }
        char[] chars = new char[count];
        this.text.getChars(offset, offset + count, chars, 0);
        return new BigDecimal(chars);
    }

    public boolean scanISO8601DateIfMatch() {
        return this.scanISO8601DateIfMatch(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean scanISO8601DateIfMatch(boolean strict) {
        char S2;
        char S1;
        char s1;
        char s0;
        char m1;
        char m0;
        char h1;
        char d1;
        char d0;
        char M1;
        char M0;
        char y3;
        char y2;
        char y1;
        char y0;
        char c5;
        char c4;
        char c3;
        char c2;
        char c1;
        char c0;
        int rest = this.len - this.bp;
        if (!strict && rest > 13) {
            c0 = this.charAt(this.bp);
            c1 = this.charAt(this.bp + 1);
            c2 = this.charAt(this.bp + 2);
            c3 = this.charAt(this.bp + 3);
            c4 = this.charAt(this.bp + 4);
            c5 = this.charAt(this.bp + 5);
            char c_r0 = this.charAt(this.bp + rest - 1);
            char c_r1 = this.charAt(this.bp + rest - 2);
            if (c0 == '/' && c1 == 'D' && c2 == 'a' && c3 == 't' && c4 == 'e' && c5 == '(' && c_r0 == '/' && c_r1 == ')') {
                int plusIndex = -1;
                for (int i = 6; i < rest; ++i) {
                    char c = this.charAt(this.bp + i);
                    if (c == '+') {
                        plusIndex = i;
                        continue;
                    }
                    if (c < '0' || c > '9') break;
                }
                if (plusIndex == -1) {
                    return false;
                }
                int offset = this.bp + 6;
                String numberText = this.subString(offset, plusIndex - offset);
                long millis = Long.parseLong(numberText);
                this.calendar = Calendar.getInstance(this.timeZone, this.locale);
                this.calendar.setTimeInMillis(millis);
                this.token = 5;
                return true;
            }
        }
        if (rest == 8 || rest == 14 || rest == 17) {
            int seconds;
            int minute;
            int hour;
            int millis;
            char d12;
            char d02;
            char M12;
            char M02;
            char y32;
            char y22;
            char y12;
            if (strict) {
                return false;
            }
            char y02 = this.charAt(this.bp);
            if (!JSONScanner.checkDate(y02, y12 = this.charAt(this.bp + 1), y22 = this.charAt(this.bp + 2), y32 = this.charAt(this.bp + 3), M02 = this.charAt(this.bp + 4), M12 = this.charAt(this.bp + 5), d02 = this.charAt(this.bp + 6), d12 = this.charAt(this.bp + 7))) {
                return false;
            }
            this.setCalendar(y02, y12, y22, y32, M02, M12, d02, d12);
            if (rest != 8) {
                char s12;
                char s02;
                char m12;
                char m02;
                char h12;
                char h0 = this.charAt(this.bp + 8);
                if (!this.checkTime(h0, h12 = this.charAt(this.bp + 9), m02 = this.charAt(this.bp + 10), m12 = this.charAt(this.bp + 11), s02 = this.charAt(this.bp + 12), s12 = this.charAt(this.bp + 13))) {
                    return false;
                }
                if (rest == 17) {
                    char S0 = this.charAt(this.bp + 14);
                    char S12 = this.charAt(this.bp + 15);
                    char S22 = this.charAt(this.bp + 16);
                    if (S0 < '0' || S0 > '9') {
                        return false;
                    }
                    if (S12 < '0' || S12 > '9') {
                        return false;
                    }
                    if (S22 < '0' || S22 > '9') {
                        return false;
                    }
                    millis = (S0 - 48) * 100 + (S12 - 48) * 10 + (S22 - 48);
                } else {
                    millis = 0;
                }
                hour = (h0 - 48) * 10 + (h12 - 48);
                minute = (m02 - 48) * 10 + (m12 - 48);
                seconds = (s02 - 48) * 10 + (s12 - 48);
            } else {
                hour = 0;
                minute = 0;
                seconds = 0;
                millis = 0;
            }
            this.calendar.set(11, hour);
            this.calendar.set(12, minute);
            this.calendar.set(13, seconds);
            this.calendar.set(14, millis);
            this.token = 5;
            return true;
        }
        if (rest < 9) {
            return false;
        }
        c0 = this.charAt(this.bp);
        c1 = this.charAt(this.bp + 1);
        c2 = this.charAt(this.bp + 2);
        c3 = this.charAt(this.bp + 3);
        c4 = this.charAt(this.bp + 4);
        c5 = this.charAt(this.bp + 5);
        char c6 = this.charAt(this.bp + 6);
        char c7 = this.charAt(this.bp + 7);
        char c8 = this.charAt(this.bp + 8);
        char c9 = this.charAt(this.bp + 9);
        if (c4 == '-' && c7 == '-' || c4 == '/' && c7 == '/') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            M0 = c5;
            M1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == '.' && c5 == '.' || c2 == '-' && c5 == '-') {
            d0 = c0;
            d1 = c1;
            M0 = c3;
            M1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else {
            if (c4 != '\u5e74' && c4 != '\ub144') return false;
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            if (c7 == '\u6708' || c7 == '\uc6d4') {
                M0 = c5;
                M1 = c6;
                if (c9 == '\u65e5' || c9 == '\uc77c') {
                    d0 = '0';
                    d1 = c8;
                } else {
                    if (this.charAt(this.bp + 10) != '\u65e5' && this.charAt(this.bp + 10) != '\uc77c') return false;
                    d0 = c8;
                    d1 = c9;
                }
            } else {
                if (c6 != '\u6708' && c6 != '\uc6d4') return false;
                M0 = '0';
                M1 = c5;
                if (c8 == '\u65e5' || c8 == '\uc77c') {
                    d0 = '0';
                    d1 = c7;
                } else {
                    if (c9 != '\u65e5' && c9 != 51068) return false;
                    d0 = c7;
                    d1 = c8;
                }
            }
        }
        if (!JSONScanner.checkDate(y0, y1, y2, y3, M0, M1, d0, d1)) {
            return false;
        }
        this.setCalendar(y0, y1, y2, y3, M0, M1, d0, d1);
        char t = this.charAt(this.bp + 10);
        if (t == 'T' || t == ' ' && !strict) {
            if (rest < 19) {
                return false;
            }
        } else {
            if (t == '\"' || t == '\u001a' || t == '\u65e5' || t == '\uc77c') {
                this.calendar.set(11, 0);
                this.calendar.set(12, 0);
                this.calendar.set(13, 0);
                this.calendar.set(14, 0);
                this.ch = this.charAt(this.bp += 10);
                this.token = 5;
                return true;
            }
            if (t != '+' && t != '-') return false;
            if (this.len != 16) return false;
            if (this.charAt(this.bp + 13) != ':' || this.charAt(this.bp + 14) != '0' || this.charAt(this.bp + 15) != '0') {
                return false;
            }
            this.setTime('0', '0', '0', '0', '0', '0');
            this.calendar.set(14, 0);
            this.setTimeZone(t, this.charAt(this.bp + 11), this.charAt(this.bp + 12));
            return true;
        }
        if (this.charAt(this.bp + 13) != ':') {
            return false;
        }
        if (this.charAt(this.bp + 16) != ':') {
            return false;
        }
        char h0 = this.charAt(this.bp + 11);
        if (!this.checkTime(h0, h1 = this.charAt(this.bp + 12), m0 = this.charAt(this.bp + 14), m1 = this.charAt(this.bp + 15), s0 = this.charAt(this.bp + 17), s1 = this.charAt(this.bp + 18))) {
            return false;
        }
        this.setTime(h0, h1, m0, m1, s0, s1);
        char dot = this.charAt(this.bp + 19);
        if (dot == '.') {
            if (rest < 21) {
                return false;
            }
        } else {
            String[] timeZoneIDs;
            this.calendar.set(14, 0);
            this.ch = this.charAt(this.bp += 19);
            this.token = 5;
            if (dot != 'Z' || this.calendar.getTimeZone().getRawOffset() == 0 || (timeZoneIDs = TimeZone.getAvailableIDs(0)).length <= 0) return true;
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
            this.calendar.setTimeZone(timeZone);
            return true;
        }
        char S0 = this.charAt(this.bp + 20);
        if (S0 < '0' || S0 > '9') {
            return false;
        }
        int millis = S0 - 48;
        int millisLen = 1;
        if (rest > 21 && (S1 = this.charAt(this.bp + 21)) >= '0' && S1 <= '9') {
            millis = millis * 10 + (S1 - 48);
            millisLen = 2;
        }
        if (millisLen == 2 && (S2 = this.charAt(this.bp + 22)) >= '0' && S2 <= '9') {
            millis = millis * 10 + (S2 - 48);
            millisLen = 3;
        }
        this.calendar.set(14, millis);
        int timzeZoneLength = 0;
        char timeZoneFlag = this.charAt(this.bp + 20 + millisLen);
        if (timeZoneFlag == '+' || timeZoneFlag == '-') {
            char t0 = this.charAt(this.bp + 20 + millisLen + 1);
            if (t0 < '0' || t0 > '1') {
                return false;
            }
            char t1 = this.charAt(this.bp + 20 + millisLen + 2);
            if (t1 < '0' || t1 > '9') {
                return false;
            }
            char t2 = this.charAt(this.bp + 20 + millisLen + 3);
            if (t2 == ':') {
                char t3 = this.charAt(this.bp + 20 + millisLen + 4);
                if (t3 != '0') {
                    return false;
                }
                char t4 = this.charAt(this.bp + 20 + millisLen + 5);
                if (t4 != '0') {
                    return false;
                }
                timzeZoneLength = 6;
            } else if (t2 == '0') {
                char t3 = this.charAt(this.bp + 20 + millisLen + 4);
                if (t3 != '0') {
                    return false;
                }
                timzeZoneLength = 5;
            } else {
                timzeZoneLength = 3;
            }
            this.setTimeZone(timeZoneFlag, t0, t1);
        } else if (timeZoneFlag == 'Z') {
            String[] timeZoneIDs;
            timzeZoneLength = 1;
            if (this.calendar.getTimeZone().getRawOffset() != 0 && (timeZoneIDs = TimeZone.getAvailableIDs(0)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
                this.calendar.setTimeZone(timeZone);
            }
        }
        char end = this.charAt(this.bp + (20 + millisLen + timzeZoneLength));
        if (end != '\u001a' && end != '\"') {
            return false;
        }
        this.ch = this.charAt(this.bp += 20 + millisLen + timzeZoneLength);
        this.token = 5;
        return true;
    }

    protected void setTime(char h0, char h1, char m0, char m1, char s0, char s1) {
        int hour = (h0 - 48) * 10 + (h1 - 48);
        int minute = (m0 - 48) * 10 + (m1 - 48);
        int seconds = (s0 - 48) * 10 + (s1 - 48);
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
        this.calendar.set(13, seconds);
    }

    protected void setTimeZone(char timeZoneFlag, char t0, char t1) {
        String[] timeZoneIDs;
        int timeZoneOffset = ((t0 - 48) * 10 + (t1 - 48)) * 3600 * 1000;
        if (timeZoneFlag == '-') {
            timeZoneOffset = -timeZoneOffset;
        }
        if (this.calendar.getTimeZone().getRawOffset() != timeZoneOffset && (timeZoneIDs = TimeZone.getAvailableIDs(timeZoneOffset)).length > 0) {
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneIDs[0]);
            this.calendar.setTimeZone(timeZone);
        }
    }

    private boolean checkTime(char h0, char h1, char m0, char m1, char s0, char s1) {
        if (h0 == '0') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '1') {
            if (h1 < '0' || h1 > '9') {
                return false;
            }
        } else if (h0 == '2') {
            if (h1 < '0' || h1 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (m0 >= '0' && m0 <= '5') {
            if (m1 < '0' || m1 > '9') {
                return false;
            }
        } else if (m0 == '6') {
            if (m1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (s0 >= '0' && s0 <= '5') {
            if (s1 < '0' || s1 > '9') {
                return false;
            }
        } else if (s0 == '6') {
            if (s1 != '0') {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void setCalendar(char y0, char y1, char y2, char y3, char M0, char M1, char d0, char d1) {
        this.calendar = Calendar.getInstance(this.timeZone, this.locale);
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        int month = (M0 - 48) * 10 + (M1 - 48) - 1;
        int day = (d0 - 48) * 10 + (d1 - 48);
        this.calendar.set(1, year);
        this.calendar.set(2, month);
        this.calendar.set(5, day);
    }

    static boolean checkDate(char y0, char y1, char y2, char y3, char M0, char M1, int d0, int d1) {
        if (y0 != '1' && y0 != '2') {
            return false;
        }
        if (y1 < '0' || y1 > '9') {
            return false;
        }
        if (y2 < '0' || y2 > '9') {
            return false;
        }
        if (y3 < '0' || y3 > '9') {
            return false;
        }
        if (M0 == '0') {
            if (M1 < '1' || M1 > '9') {
                return false;
            }
        } else if (M0 == '1') {
            if (M1 != '0' && M1 != '1' && M1 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (d0 == 48) {
            if (d1 < 49 || d1 > 57) {
                return false;
            }
        } else if (d0 == 49 || d0 == 50) {
            if (d1 < 48 || d1 > 57) {
                return false;
            }
        } else if (d0 == 51) {
            if (d1 != 48 && d1 != 49) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean isEOF() {
        return this.bp == this.len || this.ch == '\u001a' && this.bp + 1 == this.len;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int scanFieldInt(char[] fieldName) {
        int n;
        int value;
        boolean negative;
        char ch;
        int index;
        char startChar;
        int startPos;
        block20: {
            int n2;
            this.matchStat = 0;
            startPos = this.bp;
            startChar = this.ch;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                this.matchStat = -2;
                return 0;
            }
            index = this.bp + fieldName.length;
            ch = this.charAt(index++);
            negative = false;
            if (ch == '-') {
                ch = this.charAt(index++);
                negative = true;
            }
            if (ch >= '0' && ch <= '9') {
                value = ch - 48;
                while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                    value = value * 10 + (ch - 48);
                }
                if (ch == '.') {
                    this.matchStat = -1;
                    return 0;
                }
                if (value < 0) {
                    this.matchStat = -1;
                    return 0;
                }
            } else {
                this.matchStat = -1;
                return 0;
            }
            while (true) {
                if (ch == ',' || ch == '}') {
                    this.bp = index - 1;
                    if (ch == ',') {
                        break;
                    }
                    break block20;
                }
                if (!JSONScanner.isWhitespace(ch)) {
                    this.matchStat = -1;
                    return 0;
                }
                ch = this.charAt(index++);
            }
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (negative) {
                n2 = -value;
                return n2;
            }
            n2 = value;
            return n2;
        }
        if (ch == '}') {
            this.bp = index - 1;
            ch = this.charAt(++this.bp);
            while (true) {
                if (ch == ',') {
                    this.token = 16;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (ch == ']') {
                    this.token = 15;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (ch == '}') {
                    this.token = 13;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (ch == '\u001a') {
                    this.token = 20;
                    break;
                }
                if (!JSONScanner.isWhitespace(ch)) {
                    this.bp = startPos;
                    this.ch = startChar;
                    this.matchStat = -1;
                    return 0;
                }
                ch = this.charAt(++this.bp);
            }
            this.matchStat = 4;
        }
        if (negative) {
            n = -value;
            return n;
        }
        n = value;
        return n;
    }

    @Override
    public String scanFieldString(char[] fieldName) {
        String stringVal;
        int endIndex;
        char ch;
        char startChar;
        int startPos;
        block16: {
            this.matchStat = 0;
            startPos = this.bp;
            startChar = this.ch;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                this.matchStat = -2;
                return this.stringDefaultValue();
            }
            int index = this.bp + fieldName.length;
            if ((ch = this.charAt(index++)) != '\"') {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            int startIndex = index;
            endIndex = this.indexOf('\"', startIndex);
            if (endIndex == -1) {
                throw new JSONException("unclosed str");
            }
            stringVal = this.subString(startIndex, endIndex - startIndex);
            if (stringVal.indexOf(92) != -1) {
                while (true) {
                    int slashCount = 0;
                    for (int i = endIndex - 1; i >= 0 && this.charAt(i) == '\\'; --i) {
                        ++slashCount;
                    }
                    if (slashCount % 2 == 0) break;
                    endIndex = this.indexOf('\"', endIndex + 1);
                }
                int chars_len = endIndex - (this.bp + fieldName.length + 1);
                char[] chars = this.sub_chars(this.bp + fieldName.length + 1, chars_len);
                stringVal = JSONScanner.readString(chars, chars_len);
            }
            ch = this.charAt(endIndex + 1);
            while (true) {
                if (ch == ',' || ch == '}') break block16;
                if (!JSONScanner.isWhitespace(ch)) break;
                ch = this.charAt(++endIndex + 1);
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.bp = endIndex + 1;
        this.ch = ch;
        String strVal = stringVal;
        if (ch == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return strVal;
        }
        if ((ch = this.charAt(++this.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (ch == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else if (ch == '\u001a') {
            this.token = 20;
        } else {
            this.bp = startPos;
            this.ch = startChar;
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.matchStat = 4;
        return strVal;
    }

    @Override
    public long scanFieldSymbol(char[] fieldName) {
        long hash;
        block11: {
            char ch;
            this.matchStat = 0;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                this.matchStat = -2;
                return 0L;
            }
            int index = this.bp + fieldName.length;
            if ((ch = this.charAt(index++)) != '\"') {
                this.matchStat = -1;
                return 0L;
            }
            hash = -2128831035L;
            while (true) {
                if ((ch = this.charAt(index++)) == '\"') break;
                if (index > this.len) {
                    this.matchStat = -1;
                    return 0L;
                }
                hash ^= (long)ch;
                hash *= 16777619L;
            }
            this.bp = index;
            this.ch = ch = this.charAt(this.bp);
            while (true) {
                if (ch == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    return hash;
                }
                if (ch == '}') {
                    this.next();
                    this.skipWhitespace();
                    ch = this.getCurrent();
                    if (ch == ',') {
                        this.token = 16;
                        this.ch = this.charAt(++this.bp);
                        break block11;
                    }
                    if (ch == ']') {
                        this.token = 15;
                        this.ch = this.charAt(++this.bp);
                        break block11;
                    }
                    if (ch == '}') {
                        this.token = 13;
                        this.ch = this.charAt(++this.bp);
                        break block11;
                    }
                    if (ch == '\u001a') {
                        this.token = 20;
                        break block11;
                    }
                    this.matchStat = -1;
                    return 0L;
                }
                if (!JSONScanner.isWhitespace(ch)) break;
                ch = this.charAt(++this.bp);
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = 4;
        return hash;
    }

    @Override
    public Collection<String> newCollectionByType(Class<?> type) {
        if (type.isAssignableFrom(HashSet.class)) {
            HashSet<String> list = new HashSet<String>();
            return list;
        }
        if (type.isAssignableFrom(ArrayList.class)) {
            ArrayList<String> list2 = new ArrayList<String>();
            return list2;
        }
        try {
            Collection list = (Collection)type.newInstance();
            return list;
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Collection<String> scanFieldStringArray(char[] fieldName, Class<?> type) {
        Collection<String> list;
        block22: {
            boolean space;
            char ch;
            int index;
            block21: {
                block23: {
                    this.matchStat = 0;
                    if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                        this.matchStat = -2;
                        return null;
                    }
                    list = this.newCollectionByType(type);
                    index = this.bp + fieldName.length;
                    if ((ch = this.charAt(index++)) == '[') break block23;
                    if (!this.text.startsWith("ull", index)) {
                        this.matchStat = -1;
                        return null;
                    }
                    index += 3;
                    ch = this.charAt(index++);
                    list = null;
                    break block21;
                }
                ch = this.charAt(index++);
                while (true) {
                    block27: {
                        String stringVal;
                        int endIndex;
                        block25: {
                            int startIndex;
                            block26: {
                                block24: {
                                    if (ch != '\"') break block24;
                                    startIndex = index;
                                    endIndex = this.indexOf('\"', startIndex);
                                    if (endIndex == -1) {
                                        throw new JSONException("unclosed str");
                                    }
                                    stringVal = this.subString(startIndex, endIndex - startIndex);
                                    if (stringVal.indexOf(92) == -1) break block25;
                                    break block26;
                                }
                                if (ch == 'n' && this.text.startsWith("ull", index)) {
                                    index += 3;
                                    ch = this.charAt(index++);
                                    list.add(null);
                                    break block27;
                                } else if (ch == ']' && list.size() == 0) {
                                    ch = this.charAt(index++);
                                    break block21;
                                } else {
                                    this.matchStat = -1;
                                    return null;
                                }
                            }
                            while (true) {
                                int slashCount = 0;
                                for (int i = endIndex - 1; i >= 0 && this.charAt(i) == '\\'; ++slashCount, --i) {
                                }
                                if (slashCount % 2 == 0) {
                                    int chars_len = endIndex - startIndex;
                                    char[] chars = this.sub_chars(startIndex, chars_len);
                                    stringVal = JSONScanner.readString(chars, chars_len);
                                    break;
                                }
                                endIndex = this.indexOf('\"', endIndex + 1);
                            }
                        }
                        index = endIndex + 1;
                        ch = this.charAt(index++);
                        list.add(stringVal);
                    }
                    if (ch != ',') break;
                    ch = this.charAt(index++);
                }
                if (ch != ']') {
                    this.matchStat = -1;
                    return null;
                }
                ch = this.charAt(index++);
                while (JSONScanner.isWhitespace(ch)) {
                    ch = this.charAt(index++);
                }
            }
            this.bp = index;
            if (ch == ',') {
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return list;
            }
            if (ch != '}') {
                this.matchStat = -1;
                return null;
            }
            ch = this.charAt(this.bp);
            do {
                if (ch == ',') {
                    this.token = 16;
                    this.ch = this.charAt(++this.bp);
                    break block22;
                }
                if (ch == ']') {
                    this.token = 15;
                    this.ch = this.charAt(++this.bp);
                    break block22;
                }
                if (ch == '}') {
                    this.token = 13;
                    this.ch = this.charAt(++this.bp);
                    break block22;
                }
                if (ch == '\u001a') {
                    this.token = 20;
                    this.ch = ch;
                    break block22;
                }
                space = false;
                while (JSONScanner.isWhitespace(ch)) {
                    ch = this.charAt(index++);
                    this.bp = index;
                    space = true;
                }
            } while (space);
            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return list;
    }

    @Override
    public long scanFieldLong(char[] fieldName) {
        long value;
        boolean negative;
        block16: {
            this.matchStat = 0;
            int startPos = this.bp;
            char startChar = this.ch;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                this.matchStat = -2;
                return 0L;
            }
            int index = this.bp + fieldName.length;
            char ch = this.charAt(index++);
            negative = false;
            if (ch == '-') {
                ch = this.charAt(index++);
                negative = true;
            }
            if (ch >= '0' && ch <= '9') {
                value = ch - 48;
                while ((ch = this.charAt(index++)) >= '0' && ch <= '9') {
                    value = value * 10L + (long)(ch - 48);
                }
                if (ch == '.') {
                    this.matchStat = -1;
                    return 0L;
                }
                if (ch == ',' || ch == '}') {
                    this.bp = index - 1;
                }
                if (value < 0L) {
                    this.bp = startPos;
                    this.ch = startChar;
                    this.matchStat = -1;
                    return 0L;
                }
            } else {
                this.bp = startPos;
                this.ch = startChar;
                this.matchStat = -1;
                return 0L;
            }
            while (true) {
                if (ch == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    this.token = 16;
                    return negative ? -value : value;
                }
                if (ch == '}') {
                    ch = this.charAt(++this.bp);
                    while (true) {
                        if (ch == ',') {
                            this.token = 16;
                            this.ch = this.charAt(++this.bp);
                            break block16;
                        }
                        if (ch == ']') {
                            this.token = 15;
                            this.ch = this.charAt(++this.bp);
                            break block16;
                        }
                        if (ch == '}') {
                            this.token = 13;
                            this.ch = this.charAt(++this.bp);
                            break block16;
                        }
                        if (ch == '\u001a') {
                            this.token = 20;
                            break block16;
                        }
                        if (!JSONScanner.isWhitespace(ch)) break;
                        ch = this.charAt(++this.bp);
                    }
                    this.bp = startPos;
                    this.ch = startChar;
                    this.matchStat = -1;
                    return 0L;
                }
                if (!JSONScanner.isWhitespace(ch)) break;
                this.bp = index;
                ch = this.charAt(index++);
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = 4;
        return negative ? -value : value;
    }

    @Override
    public boolean scanFieldBoolean(char[] fieldName) {
        boolean value;
        block20: {
            char ch;
            this.matchStat = 0;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, fieldName)) {
                this.matchStat = -2;
                return false;
            }
            int index = this.bp + fieldName.length;
            if ((ch = this.charAt(index++)) == 't') {
                if (this.charAt(index++) != 'r') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(index++) != 'u') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(index++) != 'e') {
                    this.matchStat = -1;
                    return false;
                }
                this.bp = index;
                ch = this.charAt(this.bp);
                value = true;
            } else if (ch == 'f') {
                if (this.charAt(index++) != 'a') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(index++) != 'l') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(index++) != 's') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(index++) != 'e') {
                    this.matchStat = -1;
                    return false;
                }
                this.bp = index;
                ch = this.charAt(this.bp);
                value = false;
            } else {
                this.matchStat = -1;
                return false;
            }
            while (true) {
                if (ch == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    this.token = 16;
                    break block20;
                }
                if (ch == '}') {
                    block21: {
                        ch = this.charAt(++this.bp);
                        while (true) {
                            if (ch == ',') {
                                this.token = 16;
                                this.ch = this.charAt(++this.bp);
                                break block21;
                            }
                            if (ch == ']') {
                                this.token = 15;
                                this.ch = this.charAt(++this.bp);
                                break block21;
                            }
                            if (ch == '}') {
                                this.token = 13;
                                this.ch = this.charAt(++this.bp);
                                break block21;
                            }
                            if (ch == '\u001a') {
                                this.token = 20;
                                break block21;
                            }
                            if (!JSONScanner.isWhitespace(ch)) break;
                            ch = this.charAt(++this.bp);
                        }
                        this.matchStat = -1;
                        return false;
                    }
                    this.matchStat = 4;
                    break block20;
                }
                if (!JSONScanner.isWhitespace(ch)) break;
                ch = this.charAt(++this.bp);
            }
            this.matchStat = -1;
            return false;
        }
        return value;
    }

    @Override
    public final int scanInt(char expectNext) {
        int value;
        char chLocal;
        boolean negative;
        this.matchStat = 0;
        int offset = this.bp;
        boolean bl = negative = (chLocal = this.charAt(offset++)) == '-';
        if (negative) {
            chLocal = this.charAt(offset++);
        }
        if (chLocal >= '0' && chLocal <= '9') {
            value = chLocal - 48;
            while ((chLocal = this.charAt(offset++)) >= '0' && chLocal <= '9') {
                value = value * 10 + (chLocal - 48);
            }
            if (chLocal == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (value < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (chLocal == expectNext) {
                this.bp = offset;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return negative ? -value : value;
            }
            if (!JSONScanner.isWhitespace(chLocal)) break;
            chLocal = this.charAt(offset++);
        }
        this.matchStat = -1;
        return negative ? -value : value;
    }

    @Override
    public long scanLong(char expectNextChar) {
        long value;
        char chLocal;
        boolean negative;
        this.matchStat = 0;
        int offset = this.bp;
        boolean bl = negative = (chLocal = this.charAt(offset++)) == '-';
        if (negative) {
            chLocal = this.charAt(offset++);
        }
        if (chLocal >= '0' && chLocal <= '9') {
            value = chLocal - 48;
            while ((chLocal = this.charAt(offset++)) >= '0' && chLocal <= '9') {
                value = value * 10L + (long)(chLocal - 48);
            }
            if (chLocal == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (value < 0L) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        while (true) {
            if (chLocal == expectNextChar) {
                this.bp = offset;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return negative ? -value : value;
            }
            if (!JSONScanner.isWhitespace(chLocal)) break;
            chLocal = this.charAt(offset++);
        }
        this.matchStat = -1;
        return value;
    }

    @Override
    protected final void arrayCopy(int srcPos, char[] dest, int destPos, int length) {
        this.text.getChars(srcPos, srcPos + length, dest, destPos);
    }

    @Override
    public String info() {
        return "pos " + this.bp + ", json : " + (this.text.length() < 65536 ? this.text : this.text.substring(0, 65536));
    }
}

