/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.counter.ticket.counter.utils.CounterUtils;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={AlionsConfiguration.class, Configuration.class})
public class TicketForCpaHourlyBudgetCounter
extends AbstractViewCounter
implements HashCounter {
    @Autowired
    private AlionsConfiguration configuration;
    @Autowired
    private Configuration local;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private EventPark eventPark;
    @Reference(version="1.0.0")
    private TicketStatisticsService ticketStatisticsService;

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return String.valueOf(ticketId);
    }

    @Override
    protected long getIncrementValue(ViewRequest ticketRequest, Ticket ticket) {
        return ticket.isCPC() ? 0L : 1L;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfHourly();
    }

    @Override
    protected void afterIncrement(long val, ViewRequest viewRequest, Ticket ticket) {
        CounterUtils.doBudgetOfHourly(this, this.ticketStatisticsService, this.fetcher, this.eventPark, ticket);
    }

    @Bean
    public Consumer ticketForCpaHourlyBudgetCounterConsumer() {
        return this.createConsumer(this.local.getConsumer().getTicketCpaHourlyBudget(), this.configuration.getAccessKey(), this.configuration.getSecretKey());
    }
}

