/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter.utils;

import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.counter.event.BudgetNotEnoughOfHourlyEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.adsprod.model.so.rules.TicketTimelineRuleSo;
import com.bxm.warcar.cache.Fetcher;
import java.util.Calendar;
import java.util.EventObject;
import java.util.List;

public final class CounterUtils {
    private CounterUtils() {
    }

    public static void doBudgetOfHourly(Object source, TicketStatisticsService ticketStatisticsService, Fetcher fetcher, EventPark eventPark, Ticket ticket) {
        if (null == source) {
            return;
        }
        if (null == fetcher) {
            return;
        }
        if (null == eventPark) {
            return;
        }
        if (null == ticket) {
            return;
        }
        TicketTimelineRuleSo config = (TicketTimelineRuleSo)fetcher.fetch(TicketKeyGenerator.Filter.getTimeline(ticket.getId()), null, TicketTimelineRuleSo.class);
        if (null == config) {
            return;
        }
        int currentHour = Calendar.getInstance().get(11);
        List rules = config.getEntries();
        for (TicketTimelineRuleSo.Entry rule : rules) {
            int startHour = rule.getStartHour();
            int endHour = rule.getEndHour();
            long max = rule.getLimit();
            boolean isNow = currentHour >= startHour && currentHour < endHour;
            if (!isNow) continue;
            long budgetOfTimeline = ticketStatisticsService.getBudgetOfTimeline(ticket.getId(), startHour, endHour);
            if (budgetOfTimeline >= max) {
                eventPark.post((EventObject)new BudgetNotEnoughOfHourlyEvent(source, ticket, currentHour, startHour, endHour));
            }
            return;
        }
    }
}

