/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.facade.ticket.TicketOnoff;
import com.bxm.adsprod.facade.ticket.TicketOs;
import com.bxm.adsprod.facade.ticket.TicketPrice;
import com.bxm.adsprod.facade.ticket.TicketWeightMif;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.RandomUtils;

public class Ticket
implements Serializable {
    private static final long serialVersionUID = 9132608548480991005L;
    public static final byte SETTLE_TYPE_CPC = 1;
    public static final byte SETTLE_TYPE_CPA = 2;
    public static final byte TYPE_NORMAL = 1;
    public static final byte TYPE_STANDBY = 2;
    public static final byte STATUS_OPEN = 1;
    public static final byte STATUS_PAUSE = 2;
    public static final byte STATUS_CLOSE = 3;
    public static final byte STATUS_DELETED = 99;
    public static final int PAUSE_REASON_NONE = 0;
    public static final int PAUSE_REASON_OUT_OF_DAILYBUDGET = 1;
    public static final int PAUSE_REASON_BALANCE_NOT_ENOUGHT = 2;
    public static final int PAUSE_REASON_NO_START = 3;
    public static final int PAUSE_REASON_ENDED = 4;
    public static final int PAUSE_REASON_OUT_OF_TIMEBUDGET = 5;
    public static final int PAUSE_REASON_OTHER = 99;
    private BigInteger id;
    private String name;
    private BigInteger advertiser;
    private Byte settleType;
    private Integer price;
    private Byte type;
    private Integer budgetDaily;
    private String domainCode;
    private Double standaloneCost;
    private String url;
    private Date validStartDate;
    private Date validEndDate;
    private Byte isSupportWechat;
    private Integer userGradePassScore;
    private Byte status;
    private Integer pauseReason;
    private List<TicketOs> oss;
    private List<Tag> tags;
    private List<TicketOnoff> onoffs;
    private List<TicketAssets> assets;
    private List<TicketPrice> prices;
    private List<TicketWeightMif> mifs;
    private Date time;
    private String billid;

    public boolean isCPC() {
        return null != this.settleType && this.settleType == 1;
    }

    public boolean isNormalType() {
        return null != this.type && this.type == 1;
    }

    public boolean isAvailableForStatus() {
        return null != this.status && this.status == 1;
    }

    public boolean isAvailableForAssets() {
        if (CollectionUtils.isEmpty(this.assets)) {
            return false;
        }
        for (TicketAssets asset : this.assets) {
            if (!asset.isAvailable()) continue;
            return true;
        }
        return false;
    }

    public TicketAssets randomAssets() {
        ArrayList rst = Lists.newArrayList();
        for (TicketAssets asset : this.assets) {
            if (!asset.isAvailable()) continue;
            rst.add(asset);
        }
        return rst.size() == 0 ? null : (TicketAssets)rst.get(RandomUtils.nextInt((int)rst.size()));
    }

    public boolean isSupportedOs(int os) {
        if (CollectionUtils.isEmpty(this.oss)) {
            return false;
        }
        for (TicketOs ticketOs : this.oss) {
            if (ticketOs.getSupportOs() != os) continue;
            return true;
        }
        return false;
    }

    public boolean isSupportedWechat() {
        return null != this.isSupportWechat && this.isSupportWechat == 1;
    }

    public String getSettleTypeName() {
        if (null == this.settleType) {
            return "UNKNOWN";
        }
        return this.settleType == 1 ? "CPC" : (this.settleType == 2 ? "CPA" : "UNKNOWN");
    }

    public BigInteger getId() {
        return this.id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigInteger getAdvertiser() {
        return this.advertiser;
    }

    public void setAdvertiser(BigInteger advertiser) {
        this.advertiser = advertiser;
    }

    public Byte getSettleType() {
        return this.settleType;
    }

    public void setSettleType(Byte settleType) {
        this.settleType = settleType;
    }

    public Integer getPrice() {
        return this.price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Integer getBudgetDaily() {
        return this.budgetDaily;
    }

    public void setBudgetDaily(Integer budgetDaily) {
        this.budgetDaily = budgetDaily;
    }

    public String getDomainCode() {
        return this.domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Double getStandaloneCost() {
        return this.standaloneCost;
    }

    public void setStandaloneCost(Double standaloneCost) {
        this.standaloneCost = standaloneCost;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getValidStartDate() {
        return this.validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return this.validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public Byte getIsSupportWechat() {
        return this.isSupportWechat;
    }

    public void setIsSupportWechat(Byte isSupportWechat) {
        this.isSupportWechat = isSupportWechat;
    }

    public Byte getStatus() {
        return this.status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Integer getUserGradePassScore() {
        return this.userGradePassScore;
    }

    public void setUserGradePassScore(Integer userGradePassScore) {
        this.userGradePassScore = userGradePassScore;
    }

    public List<TicketOnoff> getOnoffs() {
        return this.onoffs;
    }

    public void setOnoffs(List<TicketOnoff> onoffs) {
        this.onoffs = onoffs;
    }

    public List<TicketOs> getOss() {
        return this.oss;
    }

    public void setOss(List<TicketOs> oss) {
        this.oss = oss;
    }

    public List<TicketAssets> getAssets() {
        return this.assets;
    }

    public void setAssets(List<TicketAssets> assets) {
        this.assets = assets;
    }

    public Integer getPauseReason() {
        return this.pauseReason;
    }

    public void setPauseReason(Integer pauseReason) {
        this.pauseReason = pauseReason;
    }

    public List<TicketPrice> getPrices() {
        return this.prices;
    }

    public void setPrices(List<TicketPrice> prices) {
        this.prices = prices;
    }

    public List<TicketWeightMif> getMifs() {
        return this.mifs;
    }

    public void setMifs(List<TicketWeightMif> mifs) {
        this.mifs = mifs;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getBillid() {
        return this.billid;
    }

    public void setBillid(String billid) {
        this.billid = billid;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

