/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;

public final class TicketKeyGenerator {
    public static KeyGenerator getAllTickets() {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ALL"});
            }
        };
    }

    public static KeyGenerator getTicketPrice(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE", parameters.get("ticketid"), parameters.get("positionid")});
            }
        };
    }

    public static KeyGenerator getTicketPriceOfTodayFirst(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE_TF", parameters.get("ticketid"), parameters.get("positionid")});
            }
        };
    }

    public static KeyGenerator getTicketPriceFloatPercent(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE_FP", parameters.get("ticketid"), parameters.get("positionid")});
            }
        };
    }

    public static KeyGenerator getTicketMif(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_MIF", parameters.get("ticketid"), parameters.get("positionid")});
            }
        };
    }

    public static KeyGenerator getTicketProfitForCpa(final LocalDate date) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PROFIT_FOR_CPA", date.format(DateTimeFormatter.ofPattern("yyyyMMdd"))});
            }
        };
    }

    public static class Temp {
        private Temp() {
        }

        public static KeyGenerator getTimelineOutOfBudget(final BigInteger ticketId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "TEMP", "TIMELINE", "OUT_OF_BUDGET", ticketId});
                }
            };
        }
    }

    public static class Weight {
        public static KeyGenerator getWeight(final BigInteger ticketId, String positionId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET", ticketId});
                }
            };
        }
    }

    public static class Statistics {
        private Statistics() {
        }

        public static KeyGenerator getBudgetOfDaily() {
            return Statistics.getBudgetOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getBudgetOfDaily(final String date) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "DAILY_BUDGET", date});
                }
            };
        }

        public static KeyGenerator getClickOfDaily() {
            return Statistics.getClickOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getClickOfDaily(final String date) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "CLICK", date});
                }
            };
        }

        public static KeyGenerator getViewOfDaily() {
            return Statistics.getViewOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getViewOfDaily(final String date) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "VIEW", date});
                }
            };
        }

        public static KeyGenerator getBudgetOfHourly() {
            return Statistics.getBudgetOfHourly(NumberUtils.toInt((String)DateHelper.format((String)"H"), (int)-1));
        }

        public static KeyGenerator getBudgetOfHourly(final int hour) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "HOURLY_BUDGET", DateHelper.format((String)"yyyyMMdd"), hour});
                }
            };
        }

        public static KeyGenerator getViewOfHourly() {
            return Statistics.getViewOfHourly(NumberUtils.toInt((String)DateHelper.format((String)"H"), (int)-1));
        }

        public static KeyGenerator getViewOfHourly(final int hour) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "HOURLY_VIEW", DateHelper.format((String)"yyyyMMdd"), hour});
                }
            };
        }

        public static KeyGenerator getClickOfDaily(BigInteger ticketId) {
            return Statistics.getClickOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getClickOfDaily(final String date, final BigInteger ticketId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_CLICK", date, ticketId});
                }
            };
        }

        public static KeyGenerator getViewOfDaily(BigInteger ticketId) {
            return Statistics.getViewOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getViewOfDaily(final String date, final BigInteger ticketId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_VIEW", date, ticketId});
                }
            };
        }

        public static KeyGenerator getClickOfWeekly(BigInteger ticketId) {
            return Statistics.getClickOfWeekly(DateHelper.format((String)"yyyyw"), ticketId);
        }

        public static KeyGenerator getClickOfWeekly(final String dateweek, final BigInteger ticketId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UWEEKLY_CLICK", dateweek, ticketId});
                }
            };
        }

        public static KeyGenerator getViewOfWeekly(BigInteger ticketId) {
            return Statistics.getViewOfWeekly(DateHelper.format((String)"yyyyw"), ticketId);
        }

        public static KeyGenerator getViewOfWeekly(final String dateweek, final BigInteger ticketId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UWEEKLY_VIEW", dateweek, ticketId});
                }
            };
        }
    }

    public static class User {
        private User() {
        }

        public static KeyGenerator getUser(final String uid) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "RECORD", "LAST", uid});
                }
            };
        }
    }

    public static class Media {
        private Media() {
        }

        public static KeyGenerator getPositions() {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "ALL"});
                }
            };
        }
    }

    public static class Advertiser {
        private Advertiser() {
        }

        public static KeyGenerator getBalance() {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "ADVERTISER", "BALANCE"});
                }
            };
        }
    }

    public static class Filter {
        private Filter() {
        }

        public static KeyGenerator getRegionDefined() {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "REGION", "DEFINED"});
                }
            };
        }

        public static KeyGenerator getRegionUndefined() {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "REGION", "UNDEFINED"});
                }
            };
        }

        public static KeyGenerator getPositionDefinedBlackList() {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "DEFINED", "BLACKLIST"});
                }
            };
        }

        public static KeyGenerator getPositionDefinedWhiteList() {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "DEFINED", "WHITELIST"});
                }
            };
        }

        public static KeyGenerator getPositionUndefined() {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "UNDEFINED"});
                }
            };
        }

        public static KeyGenerator getTimeline(final BigInteger ticketId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TIMELINE", ticketId});
                }
            };
        }
    }
}

