/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bson.BSONObject;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.InheritingExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.NestedDelegatingExpressionAggregationOperationContext;
import org.springframework.util.Assert;

public class VariableOperators {
    public static Map.AsBuilder mapItemsOf(String fieldReference) {
        return Map.itemsOf(fieldReference);
    }

    public static Map.AsBuilder mapItemsOf(AggregationExpression expression) {
        return Map.itemsOf(expression);
    }

    public static Let.LetBuilder define(Let.ExpressionVariable ... variables) {
        return Let.define(variables);
    }

    public static Let.LetBuilder define(Collection<Let.ExpressionVariable> variables) {
        return Let.define(variables);
    }

    public static class Let
    implements AggregationExpression {
        private final List<ExpressionVariable> vars;
        private final AggregationExpression expression;

        private Let(List<ExpressionVariable> vars, AggregationExpression expression) {
            this.vars = vars;
            this.expression = expression;
        }

        public static LetBuilder define(final Collection<ExpressionVariable> variables) {
            Assert.notNull(variables, (String)"Variables must not be null!");
            return new LetBuilder(){

                @Override
                public Let andApply(AggregationExpression expression) {
                    Assert.notNull((Object)expression, (String)"Expression must not be null!");
                    return new Let(new ArrayList(variables), expression);
                }
            };
        }

        public static LetBuilder define(final ExpressionVariable ... variables) {
            Assert.notNull((Object)variables, (String)"Variables must not be null!");
            return new LetBuilder(){

                @Override
                public Let andApply(AggregationExpression expression) {
                    Assert.notNull((Object)expression, (String)"Expression must not be null!");
                    return new Let(Arrays.asList(variables), expression);
                }
            };
        }

        @Override
        public DBObject toDbObject(AggregationOperationContext context) {
            return this.toLet(ExposedFields.synthetic(Fields.fields(this.getVariableNames())), context);
        }

        private String[] getVariableNames() {
            String[] varNames = new String[this.vars.size()];
            for (int i = 0; i < this.vars.size(); ++i) {
                varNames[i] = this.vars.get(i).variableName;
            }
            return varNames;
        }

        private DBObject toLet(ExposedFields exposedFields, AggregationOperationContext context) {
            BasicDBObject letExpression = new BasicDBObject();
            BasicDBObject mappedVars = new BasicDBObject();
            InheritingExposedFieldsAggregationOperationContext operationContext = new InheritingExposedFieldsAggregationOperationContext(exposedFields, context);
            for (ExpressionVariable var : this.vars) {
                mappedVars.putAll((BSONObject)this.getMappedVariable(var, context));
            }
            letExpression.put("vars", (Object)mappedVars);
            letExpression.put("in", this.getMappedIn(operationContext));
            return new BasicDBObject("$let", (Object)letExpression);
        }

        private DBObject getMappedVariable(ExpressionVariable var, AggregationOperationContext context) {
            return new BasicDBObject(var.variableName, var.expression instanceof AggregationExpression ? ((AggregationExpression)var.expression).toDbObject(context) : var.expression);
        }

        private Object getMappedIn(AggregationOperationContext context) {
            return this.expression.toDbObject(new NestedDelegatingExpressionAggregationOperationContext(context));
        }

        public static class ExpressionVariable {
            private final String variableName;
            private final Object expression;

            private ExpressionVariable(String variableName, Object expression) {
                this.variableName = variableName;
                this.expression = expression;
            }

            public static ExpressionVariable newVariable(String variableName) {
                Assert.notNull((Object)variableName, (String)"VariableName must not be null!");
                return new ExpressionVariable(variableName, null);
            }

            public ExpressionVariable forExpression(AggregationExpression expression) {
                Assert.notNull((Object)expression, (String)"Expression must not be null!");
                return new ExpressionVariable(this.variableName, expression);
            }

            public ExpressionVariable forExpression(DBObject expressionObject) {
                Assert.notNull((Object)expressionObject, (String)"Expression must not be null!");
                return new ExpressionVariable(this.variableName, expressionObject);
            }
        }

        public static interface LetBuilder {
            public Let andApply(AggregationExpression var1);
        }
    }

    public static class Map
    implements AggregationExpression {
        private Object sourceArray;
        private String itemVariableName;
        private AggregationExpression functionToApply;

        private Map(Object sourceArray, String itemVariableName, AggregationExpression functionToApply) {
            Assert.notNull((Object)sourceArray, (String)"SourceArray must not be null!");
            Assert.notNull((Object)itemVariableName, (String)"ItemVariableName must not be null!");
            Assert.notNull((Object)functionToApply, (String)"FunctionToApply must not be null!");
            this.sourceArray = sourceArray;
            this.itemVariableName = itemVariableName;
            this.functionToApply = functionToApply;
        }

        public static AsBuilder itemsOf(final String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new AsBuilder(){

                @Override
                public FunctionBuilder as(final String variableName) {
                    Assert.notNull((Object)variableName, (String)"VariableName must not be null!");
                    return new FunctionBuilder(){

                        @Override
                        public Map andApply(AggregationExpression expression) {
                            Assert.notNull((Object)expression, (String)"AggregationExpression must not be null!");
                            return new Map(Fields.field(fieldReference), variableName, expression);
                        }
                    };
                }
            };
        }

        public static AsBuilder itemsOf(final AggregationExpression source) {
            Assert.notNull((Object)source, (String)"AggregationExpression must not be null!");
            return new AsBuilder(){

                @Override
                public FunctionBuilder as(final String variableName) {
                    Assert.notNull((Object)variableName, (String)"VariableName must not be null!");
                    return new FunctionBuilder(){

                        @Override
                        public Map andApply(AggregationExpression expression) {
                            Assert.notNull((Object)expression, (String)"AggregationExpression must not be null!");
                            return new Map(source, variableName, expression);
                        }
                    };
                }
            };
        }

        @Override
        public DBObject toDbObject(AggregationOperationContext context) {
            return this.toMap(ExposedFields.synthetic(Fields.fields(this.itemVariableName)), context);
        }

        private DBObject toMap(ExposedFields exposedFields, AggregationOperationContext context) {
            BasicDBObject map = new BasicDBObject();
            InheritingExposedFieldsAggregationOperationContext operationContext = new InheritingExposedFieldsAggregationOperationContext(exposedFields, context);
            BasicDBObject input = this.sourceArray instanceof Field ? new BasicDBObject("input", (Object)context.getReference((Field)this.sourceArray).toString()) : new BasicDBObject("input", (Object)((AggregationExpression)this.sourceArray).toDbObject(context));
            map.putAll((BSONObject)context.getMappedObject((DBObject)input));
            map.put("as", (Object)this.itemVariableName);
            map.put("in", (Object)this.functionToApply.toDbObject(new NestedDelegatingExpressionAggregationOperationContext(operationContext)));
            return new BasicDBObject("$map", (Object)map);
        }

        public static interface FunctionBuilder {
            public Map andApply(AggregationExpression var1);
        }

        public static interface AsBuilder {
            public FunctionBuilder as(String var1);
        }
    }
}

