/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.cache.serialization;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.cache.serialization.Serialization;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSerialization
implements Serialization<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONSerialization.class);

    @Override
    public String serialize(Object data) {
        return JSON.toJSONString((Object)data);
    }

    @Override
    public <T> T deserialize(String modalValue, Class<T> cls) {
        return (T)JSON.parseObject((String)modalValue, cls);
    }

    @Override
    public <T> List<T> deserializeList(String modalValue, Class<T> cls) {
        return JSON.parseArray((String)modalValue, cls);
    }

    @Override
    public <T> Map<String, T> deserializeMap(String modalValue, Class<T> cls) {
        HashMap rst = Maps.newHashMap();
        Map map = (Map)JSONObject.parseObject((String)modalValue, Map.class);
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                Object o = ((JSONObject)value).toJavaObject(cls);
                rst.put(entry.getKey(), o);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("object {} is not instanceof JSONObject", value);
        }
        return rst;
    }
}

