/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.configure.loader.zk;

import com.bxm.warcar.configure.loader.zk.ZooKeeperEnvironmentLoader;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZooKeeperHolder
extends LifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperEnvironmentLoader.class);
    public static final int MAX_RETRIES = 3;
    public static final int BASE_SLEEP_TIMEMS = 3000;
    public static final int SESSION_TIMEOUT = 60000;
    private CuratorFramework zkClient;
    private final String connectString;
    private final int sessionTimeout;
    private final String namespace;

    public ZooKeeperHolder(String connectString) {
        this(connectString, 60000);
    }

    public ZooKeeperHolder(String connectString, int sessionTimeout) {
        this(connectString, sessionTimeout, null);
    }

    public ZooKeeperHolder(String connectString, int sessionTimeout, String namespace) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)connectString), (Object)"connectString cannot be blank");
        Preconditions.checkArgument((sessionTimeout >= 10000 ? 1 : 0) != 0, (Object)"sessionTimeout must be greater than 10000");
        this.connectString = connectString;
        this.sessionTimeout = sessionTimeout;
        this.namespace = namespace;
    }

    @Override
    public void doInit() {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().sessionTimeoutMs(this.sessionTimeout).connectString(this.connectString).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(3000, 3));
        if (StringUtils.isNotBlank((String)this.namespace)) {
            builder.namespace(this.namespace);
        }
        this.zkClient = builder.build();
        this.zkClient.start();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Connected to ZooKepper server: {}", (Object)this.connectString);
        }
    }

    @Override
    public void doDestroy() {
        if (null != this.zkClient) {
            this.zkClient.close();
        }
    }

    public CuratorFramework getClient() {
        return this.zkClient;
    }
}

