/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.impl;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduIpLibrary
implements IpLibrary {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiduIpLibrary.class);

    @Override
    public IP find(String ip) {
        try {
            String html = BaiduIpLibrary.getHtml(ip);
            String[] strings = BaiduIpLibrary.find(html, ip);
            return new IP("", strings[0], strings[1]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getHtml(String ip) throws IOException {
        URL url = new URL("http", "www.baidu.com", "/s?wd=" + ip);
        URLConnection connection = url.openConnection();
        connection.connect();
        List lines = IOUtils.readLines((InputStream)connection.getInputStream(), (Charset)Charset.defaultCharset());
        return ArrayUtils.toString((Object)lines);
    }

    private static String[] find(String html, String ip) throws Exception {
        Document document = Jsoup.parse((String)html);
        Element gap = document.select("span.c-gap-right").first().parent();
        String text = gap.text();
        text = StringUtils.substring((String)text, (int)(StringUtils.indexOf((String)text, (String)ip) + ip.length()), (int)text.length());
        int splitIndex = StringUtils.indexOf((String)(text = StringUtils.split((String)text, (char)' ')[0]), (String)"\u7701");
        if (splitIndex == -1) {
            splitIndex = StringUtils.indexOf((String)text, (String)"\u5e02");
        }
        String province = StringUtils.substring((String)text, (int)0, (int)splitIndex);
        String city = StringUtils.substring((String)text, (int)(splitIndex + 1), (int)(text.length() - 1));
        return new String[]{province, city};
    }

    public static void main(String[] args) {
        String ip = "112.125.71.38";
        BaiduIpLibrary baiduIpLibrary = new BaiduIpLibrary();
        System.out.println(baiduIpLibrary.find(ip));
    }
}

