/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.common.eventbus;

import com.bxm.adsprod.common.eventbus.EventListener;
import com.bxm.adsprod.common.utils.NamedThreadFactory;
import com.google.common.eventbus.AsyncEventBus;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public final class EventPark
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventPark.class);
    private static final int CORE_SIZE = Runtime.getRuntime().availableProcessors();
    private final AsyncEventBus asyncEventBus = new AsyncEventBus("async-event-bus", (Executor)new ThreadPoolExecutor(CORE_SIZE, CORE_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("MsgProducer")));

    public void post(EventObject eventObject) {
        this.asyncEventBus.post((Object)eventObject);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("EventBus post event: {}", (Object)eventObject);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (applicationContext.getParent() == null) {
            Map beansOfType = applicationContext.getBeansOfType(EventListener.class);
            Set entries = beansOfType.entrySet();
            for (Map.Entry entry : entries) {
                this.register(entry.getValue());
            }
        }
    }

    public void register(Object listener) {
        this.asyncEventBus.register(listener);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering listeners to EventPark: {}", listener);
        }
    }

    public void unregister(Object listener) {
        this.asyncEventBus.unregister(listener);
    }
}

