/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.common.pushable;

import com.bxm.adsprod.common.pushable.annotation.CachePush;
import com.bxm.warcar.cache.push.Pushable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class CachePushableBus
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachePushableBus.class);
    private ApplicationContext ctx;
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Map<String, Pushable> pushables = new HashMap<String, Pushable>();

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext();
        if (context.getParent() == null) {
            this.ctx = context;
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.lock.tryLock()) {
            throw new RuntimeException("RefreshBus is processing.");
        }
        if (this.isInitialized()) {
            throw new RuntimeException("RefreshBus has been initialized.");
        }
        try {
            Map beans = this.ctx.getBeansOfType(Pushable.class);
            for (Map.Entry entry : beans.entrySet()) {
                Pushable bean = (Pushable)entry.getValue();
                CachePush anno = bean.getClass().getAnnotation(CachePush.class);
                if (null == anno) continue;
                this.pushables.put(anno.value(), bean);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Registering bean to CachePushableBus: {}", (Object)bean);
            }
        }
        finally {
            this.initialized.set(true);
            this.lock.unlock();
        }
    }

    private boolean isInitialized() {
        return this.initialized.get();
    }

    public Pushable getRefreshable(String serviceName) {
        if (!this.isInitialized()) {
            throw new RuntimeException("RefreshBus must be initialized.");
        }
        return this.pushables.get(serviceName);
    }
}

