/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.jmxmp;

import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.socket.SocketConnection;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.GenericConnector;

public class JMXMPConnector
extends GenericConnector
implements Serializable {
    private static final long serialVersionUID = 7098019344073706637L;
    private JMXServiceURL address;
    private transient Map env;
    private static final String protocolName = "jmxmp";

    public JMXMPConnector(JMXServiceURL address) throws IOException {
        this(address, null);
    }

    public JMXMPConnector(JMXServiceURL address, Map env) throws IOException {
        super(env);
        this.env = new HashMap(env == null ? Collections.EMPTY_MAP : env);
        this.address = address;
        this.validateAddress();
    }

    private void validateAddress() throws IOException {
        if (this.address == null) {
            throw new IllegalArgumentException("JMXServiceURL must not be null");
        }
        if (!protocolName.equalsIgnoreCase(this.address.getProtocol())) {
            throw new MalformedURLException("Unknown protocol: " + this.address.getProtocol());
        }
    }

    public void connect(Map env) throws IOException {
        this.validateAddress();
        HashMap<String, Object> newEnv = new HashMap<String, Object>();
        if (this.env != null) {
            newEnv.putAll(this.env);
        }
        if (env != null) {
            EnvHelp.checkAttributes(env);
            newEnv.putAll(env);
        }
        ClassLoader defaultClassLoader = EnvHelp.resolveClientClassLoader(newEnv);
        newEnv.put("jmx.remote.default.class.loader", defaultClassLoader);
        if (!newEnv.containsKey("jmx.remote.message.connection")) {
            SocketConnection conn = new SocketConnection(this.address.getHost(), this.address.getPort());
            newEnv.put("jmx.remote.message.connection", conn);
        }
        super.connect(newEnv);
    }

    public String toString() {
        return this.getClass().getName() + ": JMXServiceURL=" + this.address;
    }
}

