/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.math.BigInteger;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;

public final class TicketKeyGenerator {
    public static KeyGenerator getAllTickets() {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ALL"});
            }
        };
    }

    public static KeyGenerator getTicketPrice(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE", parameters.get("ticketid"), parameters.get("positionid")});
            }
        };
    }

    public static KeyGenerator getTicketPriceOfTodayFirst(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE_TF", parameters.get("ticketid"), parameters.get("positionid")});
            }
        };
    }

    public static KeyGenerator getTicketPriceFloatPercent(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE_FP", parameters.get("ticketid"), parameters.get("positionid")});
            }
        };
    }

    public static KeyGenerator getTicketMif(final Map<String, Object> parameters) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_MIF", parameters.get("ticketid"), parameters.get("positionid")});
            }
        };
    }

    public static KeyGenerator getTicketProfitForCpa(final String date) {
        return new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PROFIT_FOR_CPA", date});
            }
        };
    }

    public static class Weight {
        public static KeyGenerator getWeight(final BigInteger ticketId, String positionId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET", ticketId});
                }
            };
        }
    }

    public static class Statistics {
        private Statistics() {
        }

        public static KeyGenerator getBudgetOfDaily() {
            return Statistics.getBudgetOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getBudgetOfDaily(final String date) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "DAILY_BUDGET", date});
                }
            };
        }

        public static KeyGenerator getClickOfDaily() {
            return Statistics.getClickOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getClickOfDaily(final String date) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "CLICK", date});
                }
            };
        }

        public static KeyGenerator getViewOfDaily() {
            return Statistics.getViewOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getViewOfDaily(final String date) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "VIEW", date});
                }
            };
        }

        public static KeyGenerator getBudgetOfHourly() {
            return Statistics.getBudgetOfHourly(NumberUtils.toInt((String)DateHelper.format((String)"H"), (int)-1));
        }

        public static KeyGenerator getBudgetOfHourly(final int hour) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "HOURLY_BUDGET", DateHelper.format((String)"yyyyMMdd"), hour});
                }
            };
        }

        public static KeyGenerator getViewOfHourly() {
            return Statistics.getViewOfHourly(NumberUtils.toInt((String)DateHelper.format((String)"H"), (int)-1));
        }

        public static KeyGenerator getViewOfHourly(final int hour) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "HOURLY_VIEW", DateHelper.format((String)"yyyyMMdd"), hour});
                }
            };
        }

        public static KeyGenerator getClickOfDaily(BigInteger ticketId) {
            return Statistics.getClickOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getClickOfDaily(final String date, final BigInteger ticketId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_CLICK", date, ticketId});
                }
            };
        }

        public static KeyGenerator getViewOfDaily(BigInteger ticketId) {
            return Statistics.getViewOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getViewOfDaily(final String date, final BigInteger ticketId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_VIEW", date, ticketId});
                }
            };
        }

        public static KeyGenerator getClickOfWeekly(BigInteger ticketId) {
            return Statistics.getClickOfWeekly(DateHelper.format((String)"yyyyw"), ticketId);
        }

        public static KeyGenerator getClickOfWeekly(final String dateweek, final BigInteger ticketId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UWEEKLY_CLICK", dateweek, ticketId});
                }
            };
        }

        public static KeyGenerator getViewOfWeekly(BigInteger ticketId) {
            return Statistics.getViewOfWeekly(DateHelper.format((String)"yyyyw"), ticketId);
        }

        public static KeyGenerator getViewOfWeekly(final String dateweek, final BigInteger ticketId) {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UWEEKLY_VIEW", dateweek, ticketId});
                }
            };
        }
    }

    public static class Media {
        private Media() {
        }

        public static KeyGenerator getPositions() {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "ALL"});
                }
            };
        }
    }

    public static class Advertiser {
        private Advertiser() {
        }

        public static KeyGenerator getBalance() {
            return new KeyGenerator(){

                public String generateKey() {
                    return KeyBuilder.build((Object[])new Object[]{"AD", "ADVERTISER", "BALANCE"});
                }
            };
        }
    }
}

