package com.bxm.adsprod.facade.ticket;

import java.math.BigInteger;

/**
 * @author allen
 * @since 1.0.0
 */
public interface OcpcService {

    /**
     * 出价
     * @param ticket
     * @param position
     * @return
     */
    int offer(Ticket ticket, String position) throws OcpcOfferException;

    /**
     * 重新投放
     *
     * @param ticketId
     * @param position
     * @throws IllegalStateException 重新投放重置失败
     */
    void reset(BigInteger ticketId, String position) throws IllegalStateException;

    /**
     * 当前广告券的出价是否低于底价
     * @param ticket
     * @param position
     * @return
     */
    boolean isUnderFloorPrice(Ticket ticket, String position) throws OcpcOfferException;

    /**
     * 处理有效点击，根据传入的累计消耗和有效点击数来计算报价单。
     *
     * @param ticket
     * @param position
     * @param consume
     * @param validClickCount
     */
    void doValidClick(Ticket ticket, String position, long consume, long validClickCount);

    /**
     * 根据累计消耗和有效点击数来计算下一次出价，如果低于底价那么会关闭这个广告。否则重新打开。
     *
     * @param ticket
     * @param position
     * @param consume
     * @param validClickCount
     */
    void doCloseIfNeeded(Ticket ticket, String position, long consume, long validClickCount);

    /**
     * 是否达到了关闭的条件
     *
     * 关闭条件有两个因素：点击次数+有效点击次数
     * @param ticket
     * @param position
     * @return
     */
    void doClick(Ticket ticket, String position);

    /**
     * 返回底价
     * @return
     */
    int getFloorPrice(int defaultValue);

    /**
     * 添加一个关闭的券到指定广告位的关闭池
     *
     * @param ticketId
     * @param position
     */
    void addToClosePool(BigInteger ticketId, String position);

    /**
     * 从这个广告位的关闭池中删除这个广告
     *
     * @param ticketId
     * @param position
     */
    void removeToClosePool(BigInteger ticketId, String position);

    /**
     * 该广告在这个广告位中目前是否已关闭
     *
     * @param ticketId
     * @param position
     * @return
     */
    boolean isClosed(BigInteger ticketId, String position);
}
