package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * <h3>广告券服务请求对象</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
public class TicketRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;
    @ValidateNotNull
    private String uid;
    private String imei;
    @ValidateNotNull
    private String position;
    @ValidateNotNull
    private String activity;

    /**
     * 平台
     * @see Platform
     */
    private int platform = Platform.MOBILE;

    /**
     * 用户设备操作系统
     * @see Os
     */
    private int os = Os.UNKNOWN;

    /**
     * 应用
     * @see App
     */
    private int app = App.UNKNOWN;

    /**
     * 用户IP地址
     */
    @ValidateNotNull
    private String ip;

    /**
     * 获取广告券的场景类型
     */
    private Integer scene = Scene.NONE;

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getActivity() {
        return activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public int getPlatform() {
        return platform;
    }

    public void setPlatform(int platform) {
        this.platform = platform;
    }

    public int getOs() {
        return os;
    }

    public void setOs(int os) {
        this.os = os;
    }

    public int getApp() {
        return app;
    }

    public void setApp(int app) {
        this.app = app;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
