package com.bxm.adsprod.facade.ticket;

import java.math.BigInteger;
import java.util.List;

/**
 * 广告券服务
 *
 * @author allen
 * @date 2017-12-05
 */
public interface TicketService {

    /**
     * 获取广告券
     *
     * @param request
     * @return 如果没有可用的广告券，那么会返回<code>null</code>
     */
    Ticket get(TicketRequest request);

    /**
     * 曝光广告券
     * @param viewRequest
     * @return
     * @throws IllegalTicketException
     */
    Ticket view(ViewRequest viewRequest) throws IllegalTicketException;

    /**
     * 点击广告券
     *
     * @param clickRequest
     * @return
     * @throws IllegalTicketException
     */
    Ticket click(ClickRequest clickRequest) throws IllegalTicketException;

    /**
     * 返回所有的广告券，包括有效、无效，启用、禁用。
     * @return
     */
    List<Ticket> getAllTickets();

    /**
     * 返回广告券信息
     * @param ticketId
     * @return
     */
    Ticket get(BigInteger ticketId);

    /**
     * 更新广告券状态
     * @param ticketId 广告券
     * @param status 需要更新到这个状态
     * @param reason 这个状态的原因，一般暂停才会用到
     * @return 更新是否成功
     * @see Ticket#STATUS_PAUSE
     * @see Ticket#PAUSE_REASON_OUT_OF_DAILYBUDGET
     * @throws IllegalTicketException
     */
    boolean updateTicketStatus(BigInteger ticketId, byte status, int reason) throws IllegalTicketException;

    void updateTicketGroupId(BigInteger ticketId, Long groupId);
}
