package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import com.bxm.adsprod.facade.ticket.ocpc.OcpcRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigInteger;

/**
 * @author allen
 * @since 1.0.0
 */
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface OcpcService {

    /**
     * 出价
     * @param request
     * @return
     */
    @RequestMapping("/ocpcService/offer")
    int offer(@RequestBody OcpcRequest request) throws OcpcOfferException;


    /**
     * 获取本次出价（只查询不删除）
     * @param ticketId
     * @param position
     * @return
     * @throws OcpcOfferException
     */
    @RequestMapping("/ocpcService/getOffer")
    int getOffer(@RequestParam("ticketId") BigInteger ticketId,
                 @RequestParam("position") String position) throws OcpcOfferException;

    /**
     * 处理有效点击，根据传入的累计消耗和有效点击数来计算报价单。
     *
     * @param request
     */
    @RequestMapping("/ocpcService/doValidClick")
    void doValidClick(@RequestBody OcpcRequest request);

    /**
     * 返回底价
     * @return
     */
    @RequestMapping("/ocpcService/getFloorPrice")
    int getFloorPrice();

    /**
     * 添加一个关闭的券到指定广告位的关闭池
     *
     * @param ticketId
     * @param position
     */
    @RequestMapping("/ocpcService/addToClosePool")
    void addToClosePool(@RequestParam("ticketId") BigInteger ticketId,
                        @RequestParam("position") String position);

    /**
     * 从这个广告位的关闭池中删除这个广告
     *
     * @param ticketId
     * @param position
     */
    @RequestMapping("/ocpcService/removeToClosePool")
    void removeToClosePool(@RequestParam("ticketId") BigInteger ticketId,
                           @RequestParam("position") String position);

    /**
     * 该广告在这个广告位中目前是否已关闭
     *
     * @param ticketId
     * @param position
     * @return
     */
    @RequestMapping("/ocpcService/isClosed")
    boolean isClosed(@RequestParam("ticketId") BigInteger ticketId,
                     @RequestParam("position") String position);
}
