package com.bxm.adsprod.facade.media;

import java.io.Serializable;

/**
 * @author allen
 * @date 2019/7/16
 * @since 1.0.0
 */
public class PositionAdx implements Serializable {

    private static final long serialVersionUID = -1775450705547477202L;

    /**
     * 互动广告
     */
    public static final short ADTYPE_ADX_ACTIVITY = 1;
    /**
     * 直投广告
     */
    public static final short ADTYPE_ADX_DIRECT = 2;

    /**
     * 原生
     */
    public static final short POSITION_TYPE_NATIVE = 1;
    /**
     * 图片
     */
    public static final short POSITION_TYPE_PICTURE = 2;
    /**
     * 视频
     */
    public static final short POSITION_TYPE_VIDEO = 3;
    /**
     * 文本
     */
    public static final short POSITION_TYPE_TEXT = 4;

    public static final short SETTLE_TYPE_CPC = 1;
    public static final short SETTLE_TYPE_CPA = 2;
    public static final short SETTLE_TYPE_OCPC = 3;
    public static final short SETTLE_TYPE_CPM = 4;

    private String positionId;
    private short adType;
    private short positionType;
    private String positionTypeDesc;
    private int normalRequestsRatio;
    private short settleType;
    private Short adxChannel;
    private String channelTagId;

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public short getAdType() {
        return adType;
    }

    public void setAdType(short adType) {
        this.adType = adType;
    }

    public short getPositionType() {
        return positionType;
    }

    public void setPositionType(short positionType) {
        this.positionType = positionType;
    }

    public String getPositionTypeDesc() {
        return positionTypeDesc;
    }

    public void setPositionTypeDesc(String positionTypeDesc) {
        this.positionTypeDesc = positionTypeDesc;
    }

    public int getNormalRequestsRatio() {
        return normalRequestsRatio;
    }

    public void setNormalRequestsRatio(int normalRequestsRatio) {
        this.normalRequestsRatio = normalRequestsRatio;
    }

    public short getSettleType() {
        return settleType;
    }

    public void setSettleType(short settleType) {
        this.settleType = settleType;
    }

    public Short getAdxChannel() {
        return adxChannel;
    }

    public void setAdxChannel(Short adxChannel) {
        this.adxChannel = adxChannel;
    }

    public String getChannelTagId() {
        return channelTagId;
    }

    public void setChannelTagId(String channelTagId) {
        this.channelTagId = channelTagId;
    }
}
