package com.bxm.adsprod.facade.media.sdk;

import org.apache.commons.lang3.StringUtils;

/**
 * 移动网络运营商<br/>
 *
 * @author kerry.jiang
 * @date 2019/11/5 14:09
 */
public enum ESdkIspDomain {

    /**
     * 未找到枚举项
     */
    UNDEFINED("-99","未找到枚举项"),
    /**
     * 未知
     */
    UNKNOWN("0","未知"),
    /**
     * 移动
     */
    MOBILE("1","移动"),
    /**
     * 联通
     */
    UNICOM("2","联通"),
    /**
     * 电信
     */
    TELECOM("3", "电信")
    ;

    private String code;
    private String name;

    ESdkIspDomain(String code, String name){
        this.code = code;
        this.name = name;
    }

    public static ESdkIspDomain get(String code){
        ESdkIspDomain[] arr = values();
        for (ESdkIspDomain em: arr){
            if(em.code.equals(code)){
                return em;
            }
        }
        return UNDEFINED;
    }

    public static String getName(String code){
        return getName(code, StringUtils.EMPTY);
    }

    public static String getName(String code, String def_val){
        ESdkIspDomain[] arr = values();
        for (ESdkIspDomain em: arr){
            if(em.code.equals(code)){
                return em.name;
            }
        }
        return def_val;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}