package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

import com.bxm.warcar.utils.Constants;

/**
 * @author allen
 * @date 2017-12-05
 */
public class TicketAssets implements Serializable {
    private static final long serialVersionUID = 4368329874159718574L;

    public static final int VARS_NONE = 0;
    public static final int VARS_PROVINCE = 1;
    public static final int VARS_CITY = 2;

    //券类型为【推送券】互动广告运营后台素材的字段对应关系
    //button_txt  app包名
    //intro       广告内容
    //title       广告标题
    //image       图片
    //icon        icon

    private BigInteger id;
    private String name;
    private Byte vars;
    private String content;
    private String image;
    private String intro;
    private String buttonTxt;
    private Integer   clickThreshold;
    private String title;
    private String icon;
    /**
     * 状态
     * @see com.bxm.warcar.utils.Constants#YES
     * @see com.bxm.warcar.utils.Constants#NO
     */
    private Byte status;

    /**
     * 0.横版大图600*300(默认值，原不限弹窗)
     * 1.竖版大图（原一体化弹窗）
     * 2.横版大图1280*720
     * 3.竖版大图1080*1920
     * 4.小图150*150
     * 5.竖版大图-动画素材
     */
    private String isShieldPopup;

    /**
     * 点击监测地址
     */
    private List<String> clktrackers;
    /**
     * 曝光监测地址
     */
    private List<String> imptrackers;

    /**
     * 弹窗信息ID
     */
    private Long tableId;

    /**
     * 动效图片
     */
    private List<String> dynamicImgs;

    /**
     * 动效内容
     */
    private List<String> dynamicTexts;

    /**
     * 流量占比,最多两位小数
     */
    private Double flowRatio;

    public List<String> getClktrackers() {
        return clktrackers;
    }

    public void setClktrackers(List<String> clktrackers) {
        this.clktrackers = clktrackers;
    }

    public List<String> getImptrackers() {
        return imptrackers;
    }

    public void setImptrackers(List<String> imptrackers) {
        this.imptrackers = imptrackers;
    }


    public boolean isAvailable() {
        return null != status && status.byteValue() == Constants.YES;
    }

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public String getButtonTxt() {
        return buttonTxt;
    }

    public void setButtonTxt(String buttonTxt) {
        this.buttonTxt = buttonTxt;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Byte getVars() {
        return vars;
    }

    public void setVars(Byte vars) {
        this.vars = vars;
    }

    public Integer getClickThreshold() {
        return clickThreshold;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIsShieldPopup() {
        return isShieldPopup;
    }

    public void setIsShieldPopup(String isShieldPopup) {
        this.isShieldPopup = isShieldPopup;
    }

    public void setClickThreshold(Integer clickThreshold) {
        this.clickThreshold = clickThreshold;
    }

    public Long getTableId() {
        return tableId;
    }

    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public List<String> getDynamicImgs() {
        return dynamicImgs;
    }

    public void setDynamicImgs(List<String> dynamicImgs) {
        this.dynamicImgs = dynamicImgs;
    }

    public List<String> getDynamicTexts() {
        return dynamicTexts;
    }

    public void setDynamicTexts(List<String> dynamicTexts) {
        this.dynamicTexts = dynamicTexts;
    }

    public Double getFlowRatio() {
        return flowRatio;
    }

    public void setFlowRatio(Double flowRatio) {
        this.flowRatio = flowRatio;
    }
}
