package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * <h3>广告票券绑定请求对象</h3>
 *
 * @author kerry.jiang
 * @date 2019/5/20 17:55
 */
public class BindCouponRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;
    /**
     * 设备号
     */
    @ValidateNotNull
    private String imei;
    /**
     * 广告券ID
     */
    @ValidateNotNull
    private BigInteger ticket_id;
    /**
     * 广告位ID
     */
    @ValidateNotNull
    private String position_id;
    /**
     * 票券类型,0单次唯一码，1多次唯一码，2限时码，3限量码
     */
    private Integer use_type;
    /**
     * 票券优惠码
     */
    @ValidateNotNull
    private String coupons_code;

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public BigInteger getTicket_id() {
        return ticket_id;
    }

    public void setTicket_id(BigInteger ticket_id) {
        this.ticket_id = ticket_id;
    }

    public String getPosition_id() {
        return position_id;
    }

    public void setPosition_id(String position_id) {
        this.position_id = position_id;
    }

    public Integer getUse_type() {
        return use_type;
    }

    public void setUse_type(Integer use_type) {
        this.use_type = use_type;
    }

    public String getCoupons_code() {
        return coupons_code;
    }

    public void setCoupons_code(String coupons_code) {
        this.coupons_code = coupons_code;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
