package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

/**
 * 券人群定向<br/>
 *
 * @author kerry.jiang
 * @date 2020/11/27 15:50
 */
public class TicketCrowd implements Serializable {

    private static final long serialVersionUID = 4368329874159718574L;

    /**
     * 广告券ID
     */
    private BigInteger ticketId;
    /**
     * 支持的用户标签(个推)<br/>
     * 如：list.add("A001,A002");list.add("B001,B002");<br/>
     * 过滤逻辑：(A001 or A002) and (B001 or B002)<br/>
     */
    private List<String> getuiTags;

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    public List<String> getGetuiTags() {
        return getuiTags;
    }

    public void setGetuiTags(List<String> getuiTags) {
        this.getuiTags = getuiTags;
    }
}
