package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import com.bxm.adsprod.facade.media.Position;
import com.bxm.warcar.validate.annotation.ValidateNotNull;

/**
 * <h3>广告券服务请求对象</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
public class TicketRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;

    private String spm;

    @ValidateNotNull
    private String uid;
    /**
     * 通过规则从imei/imeiMd5/androidId/androidIdMd5/oaid/idfa/idfaMd5中，获得该值
     */
    private String devUid;
    /**
     * imei
     */
    private String imei;
    /**
     * imei md5
     */
    private String imeiMd5;
    /**
     * 安卓id
     */
    private String anid;
    /**
     * 安卓id md5
     */
    private String anidMd5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * idfa
     */
    private String idfa;
    /**
     * idfa md5
     */
    private String idfaMd5;

    private String did;
    @ValidateNotNull
    private String position;
    @ValidateNotNull
    private String activity;

    /**
     * 平台
     * @see Platform
     */
    private int platform = Platform.MOBILE;

    /**
     * 用户设备操作系统
     * @see Os
     */
    private int os = Os.UNKNOWN;

    /**
     * 应用
     * @see App
     */
    private int app = App.UNKNOWN;

    /**
     * 用户IP地址
     */
    @ValidateNotNull
    private String ip;

    /**
     * 获取广告券的场景类型
     */
    private Integer scene = Scene.NONE;

    /**
     * 是否需要考虑素材
     * js/api 需要考虑素材
     * h5  不需要素材素材
     */
    private boolean needMaterials;

    /**
     * 是否直投
     */
    private boolean direct;


    /**
     * 是否为特殊活动（如卡包（0不是，1是））(后续可能还回加其他)
     */
    private int isSpecial =Activities.OTHER0;
    /**
     * ADX券ID
     */
    private BigInteger adxTicketId;

    /**
     * user-agent
     */
    private String userAgent;

    private String  hw;

    /**
     * 广告位实体
     */
    private Position positionEntity;

    /**
     * SSP广告位ID
     */
    private String sspPositionId;
    /**
     * SSP广告位场景
     */
    private Integer sspPositionScene;
    /**
     * mac
     */
    private String mac;
    /**
     * 出券类型, 1: 不出视频素材(默认)，2：只出视频素材
     */
    private Integer outType;

    public String getSpm() {
        return spm;
    }

    public void setSpm(String spm) {
        this.spm = spm;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getDevUid() {
        return devUid;
    }

    public void setDevUid(String devUid) {
        this.devUid = devUid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getImeiMd5() {
        return imeiMd5;
    }

    public void setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
    }

    public String getAnid() {
        return anid;
    }

    public void setAnid(String anid) {
        this.anid = anid;
    }

    public String getAnidMd5() {
        return anidMd5;
    }

    public void setAnidMd5(String anidMd5) {
        this.anidMd5 = anidMd5;
    }

    public String getOaid() {
        return oaid;
    }

    public void setOaid(String oaid) {
        this.oaid = oaid;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getIdfaMd5() {
        return idfaMd5;
    }

    public void setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
    }

    public String getPosition() {
        return position;
    }

    public int getIsSpecial() {
        if( this.getScene() == Scene.REWARD){//如果是激励券，全部默认不限制弹窗
            return 0;
        }
        return isSpecial;
    }

    public void setIsSpecial(int isSpecial) {
        this.isSpecial = isSpecial;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getActivity() {
        return activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public int getPlatform() {
        return platform;
    }

    public void setPlatform(int platform) {
        this.platform = platform;
    }

    public int getOs() {
        return os;
    }

    public void setOs(int os) {
        this.os = os;
    }

    public int getApp() {
        return app;
    }

    public void setApp(int app) {
        this.app = app;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public boolean isNeedMaterials() {
        return needMaterials;
    }

    public void setNeedMaterials(boolean needMaterials) {
        this.needMaterials = needMaterials;
    }

    public boolean isDirect() {
        return direct;
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getHw() {
        return hw;
    }

    public void setHw(String hw) {
        this.hw = hw;
    }

    public Position getPositionEntity() {
        return positionEntity;
    }

    public void setPositionEntity(Position positionEntity) {
        this.positionEntity = positionEntity;
    }

    public BigInteger getAdxTicketId() {
        return adxTicketId;
    }

    public void setAdxTicketId(BigInteger adxTicketId) {
        this.adxTicketId = adxTicketId;
    }

    public String getSspPositionId() {
        return sspPositionId;
    }

    public void setSspPositionId(String sspPositionId) {
        this.sspPositionId = sspPositionId;
    }

    public Integer getSspPositionScene() {
        return sspPositionScene;
    }

    public void setSspPositionScene(Integer sspPositionScene) {
        this.sspPositionScene = sspPositionScene;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public Integer getOutType() {
        return outType;
    }

    public void setOutType(Integer outType) {
        this.outType = outType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
