package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 素材模板.</br>
 * Created by zhengwangeng on 2021/6/15
 */
@Data
public class AssetsTemplate implements Serializable {

	private static final long serialVersionUID = 8255898196234336477L;

    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 快手素材模板类型：横图、竖图等。可能为空，为空的话表示未知。
     */
    private Integer type;

    /**
     * SDK模板类型
     * //@see com.bxm.adsmanager.model.enums.AssetsTemplateSdkTemplateTypeEnum
     * 1=图片，2=视频，3=动画弹窗
     */
    private Integer sdkTemplateType;

    /**
     * 模版示例图
     */
    private String demoPicture;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private Short status;

    /**
     * 素材模板内容
     */
    private List<AssetsTemplateContent> adAssetsTemplateContents;

}