package com.bxm.adsprod.facade.ticket;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * <h3>数据上报请求对象</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
public class S2sReportRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;
    /**
     * 时间戳
     */
    private Long timestamp;
    /**
     * 上报类型
     * 1、发券（曝光）
     * 2、点击
     * 3、下载
     * 4、安装
     * 5、中奖
     */
    private Integer type;
    /**
     * 行为追踪ID(变现猫ID)
     */
    private String request_id;
    /**
     * 用户ID
     */
    private String uid;
    /**
     * 媒体公钥
     */
    private String appkey;
    /**
     * 广告位ID
     */
    private String position_id;
    /**
     * 奖品ID
     */
    private String prizeid;
    /**
     * 备注
     */
    private String reason;

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getRequest_id() {
        return request_id;
    }

    public void setRequest_id(String request_id) {
        this.request_id = request_id;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getPosition_id() {
        return position_id;
    }

    public void setPosition_id(String position_id) {
        this.position_id = position_id;
    }

    public String getPrizeid() {
        return prizeid;
    }

    public void setPrizeid(String prizeid) {
        this.prizeid = prizeid;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
