package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigInteger;
import java.util.List;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2021/3/9 11:20
 */
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface TicketPositionTimesLimitService {

    /**
     * 根据广告券id获取 分时段广告位出价及限额配置集合
     * @param ticketId
     * @return
     */
    @RequestMapping("/ticketService/getConfigListByTicketId")
    List<TicketPositionTimesLimitConfig> getConfigListByTicketId(@RequestParam("ticketId") String ticketId);

    /**
     * 根据广告券id 获取 当前小时对应 的分时段广告位出价及限额配置对象
     * @param ticketId
     * @return TicketPositionTimesLimitConfig
     */
    @RequestMapping("/ticketService/getCurrentHourTimesLimitConfigByTicket")
    TicketPositionTimesLimitConfig getCurrentHourTimesLimitConfigByTicket(@RequestParam("ticketId") String ticketId);

    /**
     * 根据广告券id集合 和 广告位 获取当前小时对应的分时段广告位出价及限额配置的 id集合
     * @param ticketIds
     * @param position
     * @return
     */
    @RequestMapping("/ticketService/getCurrentHourTimesLimitConfigIdByTicket")
    List<Long>  getCurrentHourTimesLimitConfigIds(@RequestBody List<BigInteger> ticketIds,@RequestParam("position")  String position);


    /**
     * 根据配置id 获取分时段广告位出价及限额 集合
     * @param ticketId
     * @param configId
     * @return
     */
    @RequestMapping("/ticketService/getTimesLimitListByTicketIdAndConfigId")
    List<TicketPositionTimesLimit> getTimesLimitListByTicketIdAndConfigId(@RequestParam("ticketId") String ticketId ,
                                                     @RequestParam("configId") String configId);


    /**
     * 根据广告券id 获取 当前小时对应 的分时段广告位出价及限额对象
     * @param ticketId
     * @return
     */
    @RequestMapping("/ticketService/getCurrentHourListByTicketAndPosition")
    TicketPositionTimesLimit getCurrentHourTicketPositionTimesLimitByTicketAndPosition(@RequestParam("ticketId") String ticketId,
                                                                                       @RequestParam("position") String position);

}
