package com.bxm.adsprod.facade.ticket.rtb;

import lombok.Data;

import java.io.Serializable;

@Data
public class PositionRtb implements Serializable {


    private static final long serialVersionUID = -919819840121789217L;

    public interface AllSourceType {

        int KUAISHOU = 1;
        int BAIDU = 2;
        int GUANGDIANTONG =3;
    }

    private String positionId;

    /**
     * 百度所使用的的token
     */
    private String  token;

    /**
     * 1 浅层  2 深层
     */
    private Byte targetType;

    /**
     * rtb 单层目标
     */
    private String targetOneRtb;

    /**
     * rtb 深层目标
     */
    private String targetTwoRtb;

    /**
     * 头部券jsonn
     * 助力器json
     */
    private String headTicketJson;
    private String helpTicketJson;

    /**
     * 来源 1快手 2 百度
     */
    private Integer sourceType;

    @Data
    public static class TargetBXM {
        /**
         * bxm 单层目标
         * bxm 深层目标
         * 券列表，多个以逗号隔开
         */
        private Integer targetOneBxm;
        private Integer targetTwoBxm;
        private String ticketIds;
    }

    public boolean isKuaishou() {
        return this.getSourceType() == AllSourceType.KUAISHOU;
    }

    public boolean isBaidu() {
        return this.getSourceType() == AllSourceType.BAIDU;
    }

    public boolean isGuangDianTong() {
        return this.getSourceType() == AllSourceType.GUANGDIANTONG;
    }

}