package com.bxm.adsprod.facade.strategy;

import java.io.Serializable;
import java.util.List;

/**
 * @author allen
 * @date 2020-08-19
 * @since 1.0
 */
public class UniformSpeedStrategyConfiguration implements Serializable {
    private static final long serialVersionUID = 8342321786614891110L;
    private String id;
    /**
     * 日消耗限制
     */
    private long limitOfDate;
    /**
     * 分时段限制
     */
    private List<LimitOfHours> limitOfHours;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getLimitOfDate() {
        return limitOfDate;
    }

    public void setLimitOfDate(long limitOfDate) {
        this.limitOfDate = limitOfDate;
    }

    public List<LimitOfHours> getLimitOfHours() {
        return limitOfHours;
    }

    public void setLimitOfHours(List<LimitOfHours> limitOfHours) {
        this.limitOfHours = limitOfHours;
    }

    public static class LimitOfHours implements Serializable {

        private static final long serialVersionUID = -5997485702040546946L;

        private long limitOfHours;
        private Integer startHour;
        private Integer endHour;

        public long getLimitOfHours() {
            return limitOfHours;
        }

        public void setLimitOfHours(long limitOfHours) {
            this.limitOfHours = limitOfHours;
        }

        public Integer getStartHour() {
            return startHour;
        }

        public void setStartHour(Integer startHour) {
            this.startHour = startHour;
        }

        public Integer getEndHour() {
            return endHour;
        }

        public void setEndHour(Integer endHour) {
            this.endHour = endHour;
        }
    }
}
