package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateLength;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 广告位直投券请求对象
 */
@Deprecated
public class DirectTicketRequet implements Serializable {

    /**
     * 媒体
     */
    @DefaultValue("mistake_appKey")
    @ValidateLength(min = 32, max = 32)
    private String appkey;

    /**
     * 渠道
     */
    @DefaultValue("1")
    private Integer appEntrance;

    /**
     * 用户ID
     */
    @DefaultValue("mistake_uid")
    private String uid;

    /**
     * 渠道
     */
    @DefaultValue("mistake_biz")
    @ValidateNotNull
    private String business;
    /**
     * 设备类型（1-安卓 2-ios 3-web）
     */
    private Integer appos;

    /**
     * IMEI 安卓唯一标识码
     */
    private String i;

    /**
     * IDFA 苹果唯一标识符
     */
    private String f;

    /**
     * 是否是微信（1是0否）
     */
    @DefaultValue("0")
    private Integer ua;

    /**
     * 是否为小程序端（1是0否）
     */
    @DefaultValue("0")
    private String device;

    /**
     * 请求ip地址
     */
    private String ipaddress;


    public String getPositionId() {
        return StringUtils.join(new Object []{appkey, business.replaceAll("ad-|money-", "")}, "-");
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public Integer getAppEntrance() {
        return appEntrance;
    }

    public void setAppEntrance(Integer appEntrance) {
        this.appEntrance = appEntrance;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Integer getAppos() {
        return appos;
    }

    public void setAppos(Integer appos) {
        this.appos = appos;
    }

    public String getI() {
        return i;
    }

    public void setI(String i) {
        this.i = i;
    }

    public String getF() {
        return f;
    }

    public void setF(String f) {
        this.f = f;
    }

    public Integer getUa() {
        return ua;
    }

    public void setUa(Integer ua) {
        this.ua = ua;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getIpaddress() {
        return ipaddress;
    }

    public void setIpaddress(String ipaddress) {
        this.ipaddress = ipaddress;
    }
}
