package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;

import com.bxm.adsprod.facade.rules.Rule;

/**
 * tbl_ad_ticket_app_extend
 * @author 
 */
public class TicketAppExtend implements Serializable {

    private static final long serialVersionUID = 1L;

    //落地页类型，1-下载类，2-表单类，5-激励浏览
    /**
     * 下载类
     */
    public static final short PAGETYPE_DOWNLOAD = 1;
    /**
     * 表单类
     */
    public static final short PAGETYPE_FORM = 2;
    /**
     * 激励浏览
     */
    public static final short PAGETYPE_BROWSE = 5;

    //设备号定向 1.不限  2.仅设备号的流量
    /**
     * 不限
     */
    public final static short DEVICERULE_UNLIMITED = 1;
    /**
     * 有设备号的
     */
    public final static short DEVICERULE_EXIST = 2;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 券id
     */
    private Long ticketId;

    /**
     * 落地页类型，1-下载类，2-表单类，5-激励浏览
     */
    private Short pageType;

    /**
     * 下载安装包的AppID/包名
     */
    private String packageName;

    /**
     * deeplink跳转地址
     */
    private String jumpUrl;

    /**
     * 曝光监测URL
     */
    private String viewUrl;

    /**
     * 点击监测URL
     */
    private String clickUrl;

    /**
     * 视频开始播放地址监测URL
     */
    private String videoPlayStartUrl;

    /**
     * 视频播放完成地址监测URL
     */
    private String videoPlayEndUrl;

    /**
     * deeplink吊起开始监测URL
     */
    private String deeplinkStartUrl;

    /**
     * deeplink吊起成功监测URL
     */
    private String deeplinkSuccessUrl;

    /**
     * deeplink吊起失败监测URL
     */
    private String deeplinkFailUrl;

    /**
     * 未获取到App列表时投放配率 0 ~ 100
     */
    private Integer appPackageRate;

    /**
     * 设备号定向 1.不限  2.仅设备号的流量
     */
    private Short deviceRule;

    /**
     * 无包名投放配率 0到100
     */
    private Integer mediaAppPackageRate;

    /**
     * Adx无App ID 投放配率： 0到100
     */
    private Integer adxAppIdRate;

    /**
     * 百度标签定向，多个用逗号分隔
     */
    private String bdTagsOrientation;

    /**
     * 百度BES广告标签
     */
    private String bdTags;

    /**
     * ADX CPM成本
     */
    private Integer adxPrice;

    /**
     * adx出价类型
     * @see //com.bxm.adsmanager.model.enums.AdxPriceTypeEnum
     */
    private Short adxPriceType;

    /**
     * ADX成本日预算
     */
    private Integer adxBudgetDaily;

    /**
     * adx 出价目标cpa
     */
    private Integer adxTargetCpa;

    /**
     * 落地页最后一跳地址
     */
    private String landingPageEndJumpUrl;

    /**
     * 下载落地页ID
     */
    private Long downloadLandingPageId;

    /**
     * 人群包定向,多个逗号分隔
     */
    private String crowdPackageOrientation;

    /**
     * ADX 按时间段投放的配置。
     *
     * {startHour}-{endHour}-{limit}-{priceYuan},{startHour}-{endHour}-{limit}-{priceYuan}
     */
    private Rule timeBidding;

    public String getCrowdPackageOrientation() {
        return crowdPackageOrientation;
    }

    public void setCrowdPackageOrientation(String crowdPackageOrientation) {
        this.crowdPackageOrientation = crowdPackageOrientation;
    }

    public Long getDownloadLandingPageId() {
        return downloadLandingPageId;
    }

    public void setDownloadLandingPageId(Long downloadLandingPageId) {
        this.downloadLandingPageId = downloadLandingPageId;
    }

    public Short getAdxPriceType() {
        return adxPriceType;
    }

    public void setAdxPriceType(Short adxPriceType) {
        this.adxPriceType = adxPriceType;
    }

    public String getLandingPageEndJumpUrl() {
        return landingPageEndJumpUrl;
    }

    public void setLandingPageEndJumpUrl(String landingPageEndJumpUrl) {
        this.landingPageEndJumpUrl = landingPageEndJumpUrl;
    }

    public Integer getMediaAppPackageRate() {
        return mediaAppPackageRate;
    }

    public void setMediaAppPackageRate(Integer mediaAppPackageRate) {
        this.mediaAppPackageRate = mediaAppPackageRate;
    }

    public Integer getAdxAppIdRate() {
        return adxAppIdRate;
    }

    public void setAdxAppIdRate(Integer adxAppIdRate) {
        this.adxAppIdRate = adxAppIdRate;
    }

    public String getBdTagsOrientation() {
        return bdTagsOrientation;
    }

    public void setBdTagsOrientation(String bdTagsOrientation) {
        this.bdTagsOrientation = bdTagsOrientation;
    }

    public String getBdTags() {
        return bdTags;
    }

    public void setBdTags(String bdTags) {
        this.bdTags = bdTags;
    }

    public Integer getAdxPrice() {
        return adxPrice;
    }

    public void setAdxPrice(Integer adxPrice) {
        this.adxPrice = adxPrice;
    }

    public Integer getAdxBudgetDaily() {
        return adxBudgetDaily;
    }

    public void setAdxBudgetDaily(Integer adxBudgetDaily) {
        this.adxBudgetDaily = adxBudgetDaily;
    }

    public Integer getAdxTargetCpa() {
        return adxTargetCpa;
    }

    public void setAdxTargetCpa(Integer adxTargetCpa) {
        this.adxTargetCpa = adxTargetCpa;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public Short getPageType() {
        return pageType;
    }

    public void setPageType(Short pageType) {
        this.pageType = pageType;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public String getViewUrl() {
        return viewUrl;
    }

    public void setViewUrl(String viewUrl) {
        this.viewUrl = viewUrl;
    }

    public String getClickUrl() {
        return clickUrl;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    public String getVideoPlayStartUrl() {
        return videoPlayStartUrl;
    }

    public void setVideoPlayStartUrl(String videoPlayStartUrl) {
        this.videoPlayStartUrl = videoPlayStartUrl;
    }

    public String getVideoPlayEndUrl() {
        return videoPlayEndUrl;
    }

    public void setVideoPlayEndUrl(String videoPlayEndUrl) {
        this.videoPlayEndUrl = videoPlayEndUrl;
    }

    public String getDeeplinkStartUrl() {
        return deeplinkStartUrl;
    }

    public void setDeeplinkStartUrl(String deeplinkStartUrl) {
        this.deeplinkStartUrl = deeplinkStartUrl;
    }

    public String getDeeplinkSuccessUrl() {
        return deeplinkSuccessUrl;
    }

    public void setDeeplinkSuccessUrl(String deeplinkSuccessUrl) {
        this.deeplinkSuccessUrl = deeplinkSuccessUrl;
    }

    public String getDeeplinkFailUrl() {
        return deeplinkFailUrl;
    }

    public void setDeeplinkFailUrl(String deeplinkFailUrl) {
        this.deeplinkFailUrl = deeplinkFailUrl;
    }

    public Integer getAppPackageRate() {
        return appPackageRate;
    }

    public void setAppPackageRate(Integer appPackageRate) {
        this.appPackageRate = appPackageRate;
    }

    public Short getDeviceRule() {
        return deviceRule;
    }

    public void setDeviceRule(Short deviceRule) {
        this.deviceRule = deviceRule;
    }

    public Rule getTimeBidding() {
        return timeBidding;
    }

    public void setTimeBidding(Rule timeBidding) {
        this.timeBidding = timeBidding;
    }
}