package com.bxm.adsprod.facade.media;

import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * <h3>SDK错误信息</h3>
 *
 * @author kerry.jiang
 * @date 2019-9-3 11:53
 */
public class SdkErrorRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;

    /**
     * SDK版本号
     */
    @ValidateNotNull
    private String version;
    /**
     * 手机型号
     */
    @ValidateNotNull
    private String devm;
    /**
     * 操作系统
     * 1：安卓，2：IOS
     */
    @ValidateNotNull
    private Integer os;
    /**
     * 操作系统版本号
     */
    @ValidateNotNull
    private String osVersion;
    /**
     * 开发者KEY
     */
    private String appkey;
    /**
     * 广告位ID
     */
    private String position_id;
    /**
     * 错误信息
     */
    @ValidateNotNull
    private String error_msg;

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDevm() {
        return devm;
    }

    public void setDevm(String devm) {
        this.devm = devm;
    }

    public Integer getOs() {
        return os;
    }

    public void setOs(Integer os) {
        this.os = os;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getPosition_id() {
        return position_id;
    }

    public void setPosition_id(String position_id) {
        this.position_id = position_id;
    }

    public String getError_msg() {
        return error_msg;
    }

    public void setError_msg(String error_msg) {
        this.error_msg = error_msg;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
