package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import com.bxm.warcar.validate.annotation.ValidateNotNull;

/**
 * <h3>Click request</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/26
 */
public class ClickRequest extends CounterRequest implements Serializable {

    private static final long serialVersionUID = -269873396903039069L;

    private String uid;
    @ValidateNotNull
    private BigInteger ticketId;
    @ValidateNotNull
    private String position;
    /**
     * 这次点击是否是有效点击
     */
    private boolean valid = false;
    /**
     * 点击单据，这次有效点击必须是有单据可寻
     * bxm_id，目前用于从点击广告到有效点击的单号
     */
    private String billid;
    /**
     * 素材ID
     */
    private BigInteger assetsId;
    /**
     * 入口广告id
     */
    private BigInteger entrTicketId;
    /**
     * 入口素材id
     */
    private BigInteger entrAssetsId;
    /**
     * Bid id
     */
    private String bidid;
    /**
     * Outer bid id
     */
    private String obidid;
    /**
     * Adx app id
     */
    private String adxAppId;

    /**
     * 转换类型
     */
    private Integer type;

    /**
     * 有效点击是否产生计费
     */
    private boolean isCost = false;

    public ClickRequest() {
    }

    public static ClickRequest of(String uid, BigInteger ticketId) {
        return new ClickRequest(uid, ticketId);
    }

    public static ClickRequest of(String uid, BigInteger ticketId, String position) {
        return new ClickRequest(uid, ticketId, position);
    }

    public static ClickRequest of(String uid, BigInteger ticketId, String position, boolean valid, String billid) {
        return new ClickRequest(uid, ticketId, position, valid, billid);
    }

    public static ClickRequest of(String uid, BigInteger ticketId, String position, boolean valid, String billid, BigInteger assetsId) {
        return new ClickRequest(uid, ticketId, position, valid, billid, assetsId);
    }

    public ClickRequest(String uid, BigInteger ticketId) {
        this(uid, ticketId, null);
    }

    public ClickRequest(String uid, BigInteger ticketId, String position) {
        this(uid, ticketId, position, false, null);
    }

    public ClickRequest(String uid, BigInteger ticketId, String position, boolean valid, String billid) {
        this(uid, ticketId, position, valid, billid, null);
    }

    public ClickRequest(String uid, BigInteger ticketId, String position, boolean valid, String billid, BigInteger assetsId) {
        this.uid = uid;
        this.ticketId = ticketId;
        this.position = position;
        this.valid = valid;
        this.billid = billid;
        this.assetsId = assetsId;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public boolean isValid() {
        return valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getBillid() {
        return billid;
    }

    public void setBillid(String billid) {
        this.billid = billid;
    }

    public BigInteger getAssetsId() {
        return assetsId;
    }

    public void setAssetsId(BigInteger assetsId) {
        this.assetsId = assetsId;
    }

    public BigInteger getEntrTicketId() {
        return entrTicketId;
    }

    public void setEntrTicketId(BigInteger entrTicketId) {
        this.entrTicketId = entrTicketId;
    }

    public BigInteger getEntrAssetsId() {
        return entrAssetsId;
    }

    public void setEntrAssetsId(BigInteger entrAssetsId) {
        this.entrAssetsId = entrAssetsId;
    }

    public String getBidid() {
        return bidid;
    }

    public void setBidid(String bidid) {
        this.bidid = bidid;
    }

    public String getObidid() {
        return obidid;
    }

    public void setObidid(String obidid) {
        this.obidid = obidid;
    }

    public String getAdxAppId() {
        return adxAppId;
    }

    public void setAdxAppId(String adxAppId) {
        this.adxAppId = adxAppId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public boolean isCost() {
        return isCost;
    }

    public void setCost(boolean cost) {
        isCost = cost;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
