package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * 票券码基本信息.</br>
 * @author zhengwangeng
 * @date 2019年05月24日上午10:53:28
 */
public class TicketCouponsInfo implements Serializable {
    private static final long serialVersionUID = 4368329874159718574L;

    /**
     * 票券使用类型，0单次唯一码，1多次唯一码，2限时码，3限量码
     */
    public static final short USETYPE_SINGLE = 0;
    public static final short USETYPE_MULTIPLE = 1;
    public static final short USETYPE_LIMITED_TIME = 2;
    public static final short USETYPE_LIMITED_NUM = 3;

    private BigInteger id;
    private Byte useType;
    private String code;
    private Date codeStartTime;
    private Date codeEndTime;
    private Integer codeLimitNum;
    private String content;
    private String intro;
    private String packageName;

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public Byte getUseType() {
        return useType;
    }

    public void setUseType(Byte useType) {
        this.useType = useType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Date getCodeStartTime() {
        return codeStartTime;
    }

    public void setCodeStartTime(Date codeStartTime) {
        this.codeStartTime = codeStartTime;
    }

    public Date getCodeEndTime() {
        return codeEndTime;
    }

    public void setCodeEndTime(Date codeEndTime) {
        this.codeEndTime = codeEndTime;
    }

    public Integer getCodeLimitNum() {
        return codeLimitNum;
    }

    public void setCodeLimitNum(Integer codeLimitNum) {
        this.codeLimitNum = codeLimitNum;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public enum AdCouponsUseType {
        /**
         * 票券使用类型，0单次唯一码，1多次唯一码，2限时码，3限量码
         */
        USETYPE_SINGLE(TicketCouponsInfo.USETYPE_SINGLE,"单次唯一码"),
        USETYPE_MULTIPLE(TicketCouponsInfo.USETYPE_MULTIPLE,"多次唯一码"),
        USETYPE_LIMITED_TIME(TicketCouponsInfo.USETYPE_LIMITED_TIME,"限时码"),
        USETYPE_LIMITED_NUM(TicketCouponsInfo.USETYPE_LIMITED_NUM,"限量码");

        private short type;
        private String name;
        AdCouponsUseType(short type, String name){
            this.type = type;
            this.name = name;
        }

        public static String getName(short type){
            for (AdCouponsUseType type1: AdCouponsUseType.values()){
                if(type == type1.type){
                    return type1.name;
                }
            }
            return "-";
        }

        public short getType() {
            return type;
        }

        public String getName() {
            return name;
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
