package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * 模板素材.</br>
 * @author zhengwangeng
 * @date 2021/6/11.
 */
public class TicketTemplateAssets implements Serializable {

    private static final long serialVersionUID = 1733401522239243683L;

    /**
     * 素材id
     */
    private BigInteger id;

    /**
     * 广告券ID
     */
    private BigInteger ticketId;

    /**
     * 状态。0- 停用、1- 启用 2删除
     */
    private Short status;

    /**
     * 素材名称
     */
    private String assetsName;

    /**
     * 具体素材配置，JSON数组，如：[
     *         {
     *             "title": "我是标题"
     *         },
     *         {
     *             "icon": "http://www.xxx.com/1.jpg"
     *
     *         }
     *     ]
     * List<TicketTemplateAssetsConfig>
     * 解析：
     * String json = "[{\"title\":\"我是标题\"},{\"icon\":\"http://www.xxx.com/1.jpg\"}]";
     * 			List<TicketTemplateAssetsConfig> ticketTemplateAssetsConfigs = JSON.parseArray(json,
     * 					TicketTemplateAssetsConfig.class);
     */
    private String config;

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public String getAssetsName() {
        return assetsName;
    }

    public void setAssetsName(String assetsName) {
        this.assetsName = assetsName;
    }

    public String getConfig() {
        return config;
    }

    public void setConfig(String config) {
        this.config = config;
    }
}
