package com.bxm.adsprod.facade.media.sdk;

import org.apache.commons.lang3.StringUtils;

/**
 * 网络类型<br/>
 *
 * @author kerry.jiang
 * @date 2019/11/5 14:09
 */
public enum ESdkNetType {

    /**
     * 未找到枚举项
     */
    UNDEFINED("-99","未找到枚举项"),
    /**
     * 未知
     */
    UNKNOWN("0","未知"),
    /**
     * 以太网
     */
    ETHERNET("1","以太网"),
    /**
     * WIFI
     */
    WIFI("2","WIFI"),
    /**
     * 2G
     */
    MOB_2G("3", "2G"),
    /**
     * 3G
     */
    MOB_3G("4","3G"),
    /**
     * 4G
     */
    MOB_4G("5","4G"),
    /**
     * 5G
     */
    MOB_5G("6","5G"),
    ;

    private String code;
    private String name;

    ESdkNetType(String code, String name){
        this.code = code;
        this.name = name;
    }

    public static ESdkNetType get(String code){
        ESdkNetType[] arr = values();
        for (ESdkNetType em: arr){
            if(em.code.equals(code)){
                return em;
            }
        }
        return UNDEFINED;
    }

    public static String getName(String code){
        return getName(code, StringUtils.EMPTY);
    }

    public static String getName(String code, String def_val){
        ESdkNetType[] arr = values();
        for (ESdkNetType em: arr){
            if(em.code.equals(code)){
                return em.name;
            }
        }
        return def_val;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}