package com.bxm.adsprod.facade.award;

import com.bxm.adsprod.facade.ticket.*;
import com.bxm.warcar.validate.annotation.DefaultValue;
import com.bxm.warcar.validate.annotation.ValidateImeiOrIdfa;
import com.bxm.warcar.validate.annotation.ValidateNotNull;

import java.io.Serializable;

/**
 * @user xavier
 * @Description
 * @date 2018/8/29
 */
public class MediaActivityRequest implements Serializable {


    private String assetId;
    private String spm;
    private String appKey;
    private String business;
    @ValidateNotNull
    @DefaultValue("1")
    private String appEntrance;
    private String origin;
    private String uid;
    @ValidateImeiOrIdfa
    private String imei;
    private String activity;
    private int platform = Platform.MOBILE;
    private int os = Os.UNKNOWN;
    private int app = App.UNKNOWN;
    private String ip;

    /**
     * 获取广告券的场景类型
     */
    private Integer scene = Scene.NONE;

    public String getAssetId() {
        return assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public String getSpm() {
        return spm;
    }

    public void setSpm(String spm) {
        this.spm = spm;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getAppEntrance() {
        return appEntrance;
    }

    public void setAppEntrance(String appEntrance) {
        this.appEntrance = appEntrance;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getActivity() {
        return activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public int getPlatform() {
        return platform;
    }

    public void setPlatform(int platform) {
        this.platform = platform;
    }

    public int getOs() {
        return os;
    }

    public void setOs(int os) {
        this.os = os;
    }

    public int getApp() {
        return app;
    }

    public void setApp(int app) {
        this.app = app;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }
}
