package com.bxm.adsprod.model.so.rules;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 广告位行业地域规则
 * <pre>
 *     {domain}-{regionCode}
 * </pre>
 * @author allen
 * @date 2017-12-06
 */
public class PositionDomainRegionRuleSo extends AbstractTwoRule {

    @JSONField(deserialize = false, serialize = false)
    private List<Entry> entries = Lists.newArrayList();

    public List<Entry> getEntries() {
        return entries;
    }

    @Override
    protected void addItem(int one, String two) {
        this.entries.add(new Entry(one, two));
    }

    public static class Entry {

        private int domain;
        private String regionCode;

        public Entry(int domain, String regionCode) {
            this.domain = domain;
            this.regionCode = regionCode;
        }

        public int getDomain() {
            return domain;
        }

        public void setDomain(int domain) {
            this.domain = domain;
        }

        public String getRegionCode() {
            return regionCode;
        }

        public void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }
    }
}
