package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.AdsprodFacadeConstants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 数据上报-S2S<br/>
 *
 * @author kerry.jiang
 * @date 2019/10/15 18:21
 */
@FeignClient(name = AdsprodFacadeConstants.SERVER_NAME)
public interface S2sReportService {

    /**
     * 首次上报<br/>
     * http post application/json<br/>
     *
     * @param s2sReportRequest 上报信息
     */
    @RequestMapping(value = "/fristReport", method = RequestMethod.POST)
    void fristReport(@RequestBody S2sReportRequest s2sReportRequest);

    /**
     * 重试上报<br/>
     * http post application/json<br/>
     */
    @RequestMapping(value = "/retryReport", method = RequestMethod.GET)
    void retryReport();

    /**
     * 首次上报监测信息<br/>
     *
     * @param s2sTrackRequest 上报信息
     */
    @RequestMapping(value = "/fristTrack", method = RequestMethod.POST)
    void fristTrack(@RequestBody S2sTrackRequest s2sTrackRequest);
}
