package com.bxm.adsprod.facade.media;

import com.bxm.warcar.utils.TypeHelper;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

/**
 * @author allen
 * @date 2022-09-27
 * @since 1.0
 */
@Data
public class MediaPosition {

    /**
     * 媒体ID
     */
    private Long mediaId;
    /**
     * 广告位ID
     */
    private String positionId;
    /**
     * 开发者代号
     */
    private Long code;
    /**
     * 入口ID
     */
    private Long appEntranceId;
    /**
     * 账号类型， 1：其他帐号/原来的账号类型都是其他， 2：ADX账号
     */
    private Byte accountTypeCode;
    /**
     * 是否删除（逻辑删除）
     */
    private Boolean deletedFlag;
    /**
     * 是否已关闭
     */
    private Boolean closedFlag;
    /**
     * 小程序投放开关
     */
    private Boolean wechatMiniAppPutFlag;
    /**
     * 地区类型 0：国内(默认) 1：海外
     */
    private Integer areaType;

    /**
     * @return 返回广告位代号，类似：008781-1
     */
    public String getPositionCode() {
        return StringUtils.leftPad(TypeHelper.castToString(getCode()), 6, '0') + "-" + getAppEntranceId();
    }
}
