package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import com.bxm.adsprod.facade.media.Position;
import com.bxm.warcar.validate.annotation.ValidateNotNull;

/**
 * <h3>广告券服务请求对象</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
public class TicketRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;

    private String spm;

    @ValidateNotNull
    private String uid;
    /**
     * 通过规则从imei/imeiMd5/androidId/androidIdMd5/oaid/idfa/idfaMd5中，获得该值
     */
    private String devUid;
    /**
     * imei
     */
    private String imei;
    /**
     * imei md5
     */
    private String imeiMd5;
    /**
     * 安卓id
     */
    private String anid;
    /**
     * 安卓id md5
     */
    private String anidMd5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    private String oaidMd5;
    /**
     * idfa
     */
    private String idfa;
    /**
     * idfa md5
     */
    private String idfaMd5;
    /**
     * Google android ID
     */
    private String gaid;
    /**
     * Google android ID md5
     */
    private String gaidMd5;

    @Deprecated
    private String did;

    /**
     * 加密后的设备信息
     */
    private String device;

    @ValidateNotNull
    private String position;
    @ValidateNotNull
    private String activity;

    /**
     * 平台
     * @see Platform
     */
    private int platform = Platform.MOBILE;

    /**
     * 用户设备操作系统
     * @see Os
     */
    private int os = Os.UNKNOWN;

    /**
     * 应用
     * @see App
     */
    private int app = App.UNKNOWN;

    /**
     * 用户IP地址
     */
    @ValidateNotNull
    private String ip;

    /**
     * 获取广告券的场景类型
     */
    private Integer scene = Scene.NONE;

    /**
     * 是否需要考虑素材
     * js/api 需要考虑素材
     * h5  不需要素材素材
     */
    private boolean needMaterials;

    /**
     * 是否直投
     */
    private boolean direct;


    /**
     * 是否为特殊活动（如卡包（0不是，1是））(后续可能还回加其他)
     */
    private int isSpecial =Activities.OTHER0;
    /**
     * ADX券ID
     */
    private BigInteger adxTicketId;

    /**
     * user-agent
     */
    private String userAgent;

    private String  hw;

    /**
     * 广告位实体
     */
    private Position positionEntity;

    /**
     * SSP广告位ID
     */
    private String sspPositionId;
    /**
     * SSP广告位场景
     */
    private Integer sspPositionScene;
    /**
     * mac
     */
    private String mac;
    /**
     * 出券类型, 1: 不出视频素材(默认)，2：只出视频素材
     */
    private Integer outType;

    /**
     * 是否需要返回权益列表
     */
    private Boolean isNeedTicketRights = false;

    /**
     * 是否需要请求FM出券接口
     */
    private Boolean isNeedFM = false;

    /**
     * 是否是指定广告位（广告位和券的黑白名单）的模拟可出券列表
     */
    private Boolean positionBlackAndWhiteList = false;


    /**
     * 特殊定制的券id，只能在某些广告位的活动上出
     */
    private String needTicketId;
    /**
     * 不能出的券id
     */
    private String notNeedTicketId;
    /**
     * 百度的appId
     * 包名
     */
    private  String appId;
    private String bundle;

    public boolean isMicroMessenger() {
        return App.WECHAT == getApp();
    }

    /**
     * 用户行为相关（百度的特征）
     */
    private  String ed;


    /**
     * isadx 判断是否ADX流量
     * ea 是入口广告ID
     */
    private  String ea;
    private  String isadx;

    /**
     * 是否支持下载广告券，1 表示支持，其他表示不支持。
     */
    private String idl;

    public Boolean getPositionBlackAndWhiteList() {
        return positionBlackAndWhiteList;
    }

    public void setPositionBlackAndWhiteList(Boolean positionBlackAndWhiteList) {
        this.positionBlackAndWhiteList = positionBlackAndWhiteList;
    }

    public String getSpm() {
        return spm;
    }

    public void setSpm(String spm) {
        this.spm = spm;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getDevUid() {
        return devUid;
    }

    public void setDevUid(String devUid) {
        this.devUid = devUid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getImeiMd5() {
        return imeiMd5;
    }

    public void setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
    }

    public String getAnid() {
        return anid;
    }

    public void setAnid(String anid) {
        this.anid = anid;
    }

    public String getAnidMd5() {
        return anidMd5;
    }

    public void setAnidMd5(String anidMd5) {
        this.anidMd5 = anidMd5;
    }

    public String getOaid() {
        return oaid;
    }

    public void setOaid(String oaid) {
        this.oaid = oaid;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getIdfaMd5() {
        return idfaMd5;
    }

    public void setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
    }

    public String getGaid() {
        return gaid;
    }

    public void setGaid(String gaid) {
        this.gaid = gaid;
    }

    public String getGaidMd5() {
        return gaidMd5;
    }

    public void setGaidMd5(String gaidMd5) {
        this.gaidMd5 = gaidMd5;
    }

    public String getPosition() {
        return position;
    }

    public int getIsSpecial() {
        if( this.getScene() == Scene.REWARD){//如果是激励券，全部默认不限制弹窗
            return 0;
        }
        return isSpecial;
    }

    public void setIsSpecial(int isSpecial) {
        this.isSpecial = isSpecial;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getActivity() {
        return activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public int getPlatform() {
        return platform;
    }

    public void setPlatform(int platform) {
        this.platform = platform;
    }

    public int getOs() {
        return os;
    }

    public void setOs(int os) {
        this.os = os;
    }

    public int getApp() {
        return app;
    }

    public void setApp(int app) {
        this.app = app;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public boolean isNeedMaterials() {
        return needMaterials;
    }

    public void setNeedMaterials(boolean needMaterials) {
        this.needMaterials = needMaterials;
    }

    public Boolean getNeedFM() {
        return isNeedFM;
    }

    public String getEd() {
        return ed;
    }

    public void setEd(String ed) {
        this.ed = ed;
    }

    public void setNeedFM(Boolean needFM) {
        isNeedFM = needFM;
    }

    public boolean isDirect() {
        return direct;
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getHw() {
        return hw;
    }

    public void setHw(String hw) {
        this.hw = hw;
    }

    public Position getPositionEntity() {
        return positionEntity;
    }

    public void setPositionEntity(Position positionEntity) {
        this.positionEntity = positionEntity;
    }

    public BigInteger getAdxTicketId() {
        return adxTicketId;
    }

    public void setAdxTicketId(BigInteger adxTicketId) {
        this.adxTicketId = adxTicketId;
    }

    public String getSspPositionId() {
        return sspPositionId;
    }

    public void setSspPositionId(String sspPositionId) {
        this.sspPositionId = sspPositionId;
    }

    public Integer getSspPositionScene() {
        return sspPositionScene;
    }

    public void setSspPositionScene(Integer sspPositionScene) {
        this.sspPositionScene = sspPositionScene;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public Integer getOutType() {
        return outType;
    }

    public Boolean getNeedTicketRights() {
        return isNeedTicketRights;
    }

    public void setNeedTicketRights(Boolean needTicketRights) {
        isNeedTicketRights = needTicketRights;
    }

    public String getNeedTicketId() {
        return needTicketId;
    }

    public void setNeedTicketId(String needTicketId) {
        this.needTicketId = needTicketId;
    }

    public String getAppId() {
        return appId;
    }

    public String getEa() {
        return ea;
    }

    public void setEa(String ea) {
        this.ea = ea;
    }

    public String getIsadx() {
        return isadx;
    }

    public void setIsadx(String isadx) {
        this.isadx = isadx;
    }

    public String getNotNeedTicketId() {
        return notNeedTicketId;
    }

    public void setNotNeedTicketId(String notNeedTicketId) {
        this.notNeedTicketId = notNeedTicketId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setOutType(Integer outType) {
        this.outType = outType;
    }

    public String getDevice() {
        return device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public String getIdl() {
        return idl;
    }

    public void setIdl(String idl) {
        this.idl = idl;
    }

    public String getBundle() {
        return bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public boolean isSupportDownload() {
        return StringUtils.equals("1", getIdl());
    }

    public String getOaidMd5() {
        return oaidMd5;
    }

    public void setOaidMd5(String oaidMd5) {
        this.oaidMd5 = oaidMd5;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
