package com.bxm.adsprod.facade.resolve;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.*;

/**
 * @author: zm
 * @Date: 2019/8/1  18:39
 * @Description: 解析参数字段生成url参数
 */
public class UrlParamResolver {

    public static final Logger logger = LoggerFactory.getLogger(UrlParamResolver.class);

    /**
     * 生成附加参数的url
     *
     * @param path   path
     * @param object
     * @return url
     */
    public static String generateUrlParam(String path, Object object) {
        if (object == null) {
            return StringUtils.EMPTY;
        }
        Set<Field> fieldSet = new HashSet<>();
        Class tempClass = object.getClass();
        while (tempClass != null && tempClass != Object.class) {
            fieldSet.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            //得到父类,然后赋给自己
            tempClass = tempClass.getSuperclass();
        }
        StringBuilder sb = new StringBuilder(path);
        sb.append("?");
        for (Field field : fieldSet) {
            if (field.isAnnotationPresent(UrlParam.class)) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                UrlParam urlParam = field.getAnnotation(UrlParam.class);
                //是否使用固定值
                UseFixedValue useFixedValue = field.getAnnotation(UseFixedValue.class);
                String value = null;
                if (useFixedValue==null) {
                    try {
                        Object fieldValue = field.get(object);
                        if (fieldValue != null) {
                            value = fieldValue instanceof String ? (String) fieldValue : String.valueOf(fieldValue);
                        }
                    } catch (IllegalAccessException e) {
                        logger.error("resolve field @UrlParam error ", e);
                    }
                }else{
                    value=useFixedValue.value();
                }
                //为空 则使用默认值
                if (value == null) {
                    value = urlParam.defaultValue();
                }

                if (StringUtils.isNotBlank(value)) {
                    sb.append(urlParam.urlParamName()).append("=").append(value).append("&");
                }
            }
        }
        //删除最后一位&
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString().trim();
    }

    /**
     * @param object
     * @return
     */
    public static Map<String, Object> generatePostParam(Object object) {
        if (object == null) {
            return Collections.EMPTY_MAP;
        }
        Map<String, Object> paramsMap = new HashMap<>(16);
        Set<Field> fieldSet = new HashSet<>();
        Class tempClass = object.getClass();
        while (tempClass != null && tempClass != Object.class) {
            fieldSet.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            tempClass = tempClass.getSuperclass();
        }

        for (Field field : fieldSet) {
            if (field.isAnnotationPresent(UrlParam.class)) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                UrlParam urlParam = field.getAnnotation(UrlParam.class);
                UseFixedValue useFixedValue = field.getAnnotation(UseFixedValue.class);
                Object value = null;
                if (useFixedValue==null) {
                    try {
                        value = field.get(object);
                    } catch (IllegalAccessException e) {
                        logger.error("resolve field @UrlParam error ", e);
                    }
                }else{
                    value=useFixedValue.value();
                }
                //为空 则使用默认值
                if (value == null) {
                    value = urlParam.defaultValue();
                }
                if (value!=null) {
                    paramsMap.put(urlParam.urlParamName(), value);
                }else{
                    paramsMap.put(urlParam.urlParamName(), StringUtils.EMPTY);
                }
            }
        }
        return paramsMap;
    }
}
